"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulePreviewContextProvider = RulePreviewContextProvider;
exports.useRulePreviewContext = useRulePreviewContext;
var _intlUtils = require("@formatjs/intl-utils");
var _useSet = _interopRequireDefault(require("react-use/lib/useSet"));
var _react = _interopRequireWildcard(require("react"));
var _usePrevious = _interopRequireDefault(require("react-use/lib/usePrevious"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/upgrade_prebuilt_rules_table/rule_preview_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RulePreviewContext = /*#__PURE__*/(0, _react.createContext)(null);
function RulePreviewContextProvider({
  children,
  ruleId
}) {
  const [editedFields, {
    add,
    remove,
    reset
  }] = (0, _useSet.default)();
  const prevRuleId = (0, _usePrevious.default)(ruleId);
  (0, _react.useEffect)(() => {
    if (ruleId !== prevRuleId) {
      reset();
    }
  }, [reset, ruleId, prevRuleId]);
  const isEditingRule = editedFields.size > 0;
  const contextValue = (0, _react.useMemo)(() => ({
    isEditingRule,
    setFieldEditing: add,
    setFieldReadonly: remove
  }), [isEditingRule, add, remove]);
  return /*#__PURE__*/_react.default.createElement(RulePreviewContext.Provider, {
    value: contextValue,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 10
    }
  }, children);
}
function useRulePreviewContext() {
  const context = (0, _react.useContext)(RulePreviewContext);
  (0, _intlUtils.invariant)(context !== null, 'useRulePreviewContext must be used inside a RulePreviewContextProvider');
  return context;
}