"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternsForm = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var i18n = _interopRequireWildcard(require("../../../../../common/translations"));
var _constants = require("../../../../../../../common/constants");
var _kibana = require("../../../../../../common/lib/kibana");
var _rule_management = require("../../../../../../../common/api/detection_engine/rule_management");
var _shared_imports = require("../../../../../../shared_imports");
var _bulk_edit_form_wrapper = require("./bulk_edit_form_wrapper");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management_ui/components/rules_table/bulk_actions/forms/index_patterns_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CommonUseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const schema = {
  index: {
    fieldsToValidateOnChange: ['index'],
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    validations: [{
      validator: _shared_imports.fieldValidators.emptyField(i18n.BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_REQUIRED_ERROR)
    }]
  },
  overwrite: {
    type: _shared_imports.FIELD_TYPES.CHECKBOX,
    label: i18n.BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_OVERWRITE_LABEL
  },
  overwriteDataViews: {
    type: _shared_imports.FIELD_TYPES.CHECKBOX,
    label: i18n.BULK_EDIT_FLYOUT_FORM_DATA_VIEWS_OVERWRITE_LABEL
  }
};
const initialFormData = {
  index: [],
  overwrite: false,
  overwriteDataViews: false
};
const getFormConfig = editAction => editAction === _rule_management.BulkActionEditTypeEnum.add_index_patterns ? {
  indexLabel: i18n.BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_LABEL,
  indexHelpText: i18n.BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_HELP_TEXT,
  formTitle: i18n.BULK_EDIT_FLYOUT_FORM_ADD_INDEX_PATTERNS_TITLE
} : {
  indexLabel: i18n.BULK_EDIT_FLYOUT_FORM_DELETE_INDEX_PATTERNS_LABEL,
  indexHelpText: i18n.BULK_EDIT_FLYOUT_FORM_DELETE_INDEX_PATTERNS_HELP_TEXT,
  formTitle: i18n.BULK_EDIT_FLYOUT_FORM_DELETE_INDEX_PATTERNS_TITLE
};
const IndexPatternsFormComponent = ({
  editAction,
  rulesCount,
  onClose,
  onConfirm
}) => {
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: initialFormData,
    schema
  });
  const {
    indexHelpText,
    indexLabel,
    formTitle
  } = getFormConfig(editAction);
  const [{
    overwrite,
    overwriteDataViews
  }] = (0, _shared_imports.useFormData)({
    form,
    watch: ['overwrite', 'overwriteDataViews']
  });
  const {
    uiSettings
  } = (0, _kibana.useKibana)().services;
  const defaultPatterns = uiSettings.get(_constants.DEFAULT_INDEX_KEY);
  const handleSubmit = async () => {
    const {
      data,
      isValid
    } = await form.submit();
    if (!isValid) {
      return;
    }
    onConfirm({
      value: data.index,
      type: data.overwrite ? _rule_management.BulkActionEditTypeEnum.set_index_patterns : editAction,
      overwrite_data_views: data.overwriteDataViews
    });
  };
  return /*#__PURE__*/_react.default.createElement(_bulk_edit_form_wrapper.BulkEditFormWrapper, {
    form: form,
    onClose: onClose,
    onSubmit: handleSubmit,
    title: formTitle,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 127,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "index",
    config: {
      ...schema.index,
      label: indexLabel,
      helpText: indexHelpText
    },
    componentProps: {
      idAria: 'bulkEditRulesIndexPatterns',
      'data-test-subj': 'bulkEditRulesIndexPatterns',
      euiFieldProps: {
        fullWidth: true,
        placeholder: '',
        noSuggestions: false,
        options: defaultPatterns.map(label => ({
          label
        }))
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }), editAction === _rule_management.BulkActionEditTypeEnum.add_index_patterns && /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "overwrite",
    componentProps: {
      idAria: 'bulkEditRulesOverwriteIndexPatterns',
      'data-test-subj': 'bulkEditRulesOverwriteIndexPatterns'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  }), overwrite && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 152,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "s",
    "data-test-subj": "bulkEditRulesIndexPatternsWarning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.setIndexPatternsWarningCallout",
    defaultMessage: "You\u2019re about to overwrite index patterns for {rulesCount, plural, one {# selected rule} other {# selected rules}}, press Save to apply changes.",
    values: {
      rulesCount
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 13
    }
  }))), editAction === _rule_management.BulkActionEditTypeEnum.add_index_patterns && /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "overwriteDataViews",
    componentProps: {
      idAria: 'bulkEditRulesOverwriteRulesWithDataViews',
      'data-test-subj': 'bulkEditRulesOverwriteRulesWithDataViews'
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 9
    }
  }), overwriteDataViews && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "s",
    "data-test-subj": "bulkEditRulesDataViewsWarning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 174,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.setDataViewsOverwriteWarningCallout",
    defaultMessage: "If you have selected rules which depend on a data view this action will force those rules to read from the index pattern as defined after this update, not the dataview, and may result in broken rules.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 175,
      columnNumber: 13
    }
  }))), editAction === _rule_management.BulkActionEditTypeEnum.delete_index_patterns && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "s",
    "data-test-subj": "bulkEditRulesDataViewsWarning",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.deleteIndexPattnersDataViewsOverwriteWarningCallout",
    defaultMessage: "If you have selected rules which depend on a data view this action will not have any effect on those rules.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 185,
      columnNumber: 13
    }
  }))));
};
const IndexPatternsForm = exports.IndexPatternsForm = /*#__PURE__*/_react.default.memo(IndexPatternsFormComponent);
IndexPatternsForm.displayName = 'IndexPatternsForm';