"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExecuteBulkAction = exports.goToRuleEditPage = void 0;
var _react = require("react");
var _constants = require("../../../../../common/constants");
var _rule_management = require("../../../../../common/api/detection_engine/rule_management");
var _types = require("../../../../app/types");
var _redirect_to_detection_engine = require("../../../../common/components/link_to/redirect_to_detection_engine");
var _telemetry = require("../../../../common/lib/telemetry");
var _rules_table_context = require("../../../rule_management_ui/components/rules_table/rules_table/rules_table_context");
var _use_bulk_action_mutation = require("../../api/hooks/use_bulk_action_mutation");
var _use_show_bulk_error_toast = require("./use_show_bulk_error_toast");
var _use_show_bulk_success_toast = require("./use_show_bulk_success_toast");
var _use_guess_rule_ids_for_bulk_action = require("./use_guess_rule_ids_for_bulk_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const goToRuleEditPage = (ruleId, navigateToApp) => {
  navigateToApp(_constants.APP_UI_ID, {
    deepLinkId: _types.SecurityPageName.rules,
    path: (0, _redirect_to_detection_engine.getEditRuleUrl)(ruleId !== null && ruleId !== void 0 ? ruleId : '')
  });
};
exports.goToRuleEditPage = goToRuleEditPage;
const useExecuteBulkAction = options => {
  const {
    mutateAsync
  } = (0, _use_bulk_action_mutation.useBulkActionMutation)();
  const showBulkSuccessToast = (0, _use_show_bulk_success_toast.useShowBulkSuccessToast)();
  const showBulkErrorToast = (0, _use_show_bulk_error_toast.useShowBulkErrorToast)();
  const guessRuleIdsForBulkAction = (0, _use_guess_rule_ids_for_bulk_action.useGuessRuleIdsForBulkAction)();
  const rulesTableContext = (0, _rules_table_context.useRulesTableContextOptional)();
  const setLoadingRules = rulesTableContext === null || rulesTableContext === void 0 ? void 0 : rulesTableContext.actions.setLoadingRules;
  const executeBulkAction = (0, _react.useCallback)(async bulkAction => {
    try {
      var _bulkAction$ids;
      setLoadingRules === null || setLoadingRules === void 0 ? void 0 : setLoadingRules({
        ids: (_bulkAction$ids = bulkAction.ids) !== null && _bulkAction$ids !== void 0 ? _bulkAction$ids : guessRuleIdsForBulkAction(bulkAction.type),
        action: bulkAction.type
      });
      const response = await mutateAsync({
        bulkAction
      });
      sendTelemetry(bulkAction.type, response);
      if (!(options !== null && options !== void 0 && options.suppressSuccessToast)) {
        showBulkSuccessToast({
          actionType: bulkAction.type,
          summary: response.attributes.summary,
          editPayload: bulkAction.type === _rule_management.BulkActionTypeEnum.edit ? bulkAction.editPayload : undefined
        });
      }
      return response;
    } catch (error) {
      showBulkErrorToast({
        actionType: bulkAction.type,
        error
      });
    } finally {
      setLoadingRules === null || setLoadingRules === void 0 ? void 0 : setLoadingRules({
        ids: [],
        action: null
      });
    }
  }, [options === null || options === void 0 ? void 0 : options.suppressSuccessToast, guessRuleIdsForBulkAction, setLoadingRules, mutateAsync, showBulkSuccessToast, showBulkErrorToast]);
  return {
    executeBulkAction
  };
};
exports.useExecuteBulkAction = useExecuteBulkAction;
function sendTelemetry(action, response) {
  if (action !== _rule_management.BulkActionTypeEnum.disable && action !== _rule_management.BulkActionTypeEnum.enable) {
    return;
  }
  if (response.attributes.results.updated.some(rule => rule.immutable)) {
    (0, _telemetry.track)(_telemetry.METRIC_TYPE.COUNT, action === _rule_management.BulkActionTypeEnum.enable ? _telemetry.TELEMETRY_EVENT.SIEM_RULE_ENABLED : _telemetry.TELEMETRY_EVENT.SIEM_RULE_DISABLED);
  }
  if (response.attributes.results.updated.some(rule => !rule.immutable)) {
    (0, _telemetry.track)(_telemetry.METRIC_TYPE.COUNT, action === _rule_management.BulkActionTypeEnum.disable ? _telemetry.TELEMETRY_EVENT.CUSTOM_RULE_DISABLED : _telemetry.TELEMETRY_EVENT.CUSTOM_RULE_ENABLED);
  }
}