"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRuleCustomizationsContext = exports.RuleCustomizationsContextProvider = exports.RuleCustomizationsContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _invariant = require("../../../../../../common/utils/invariant");
var _use_rule_customizations_diff = require("./use_rule_customizations_diff");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_management/components/rule_details/rule_customizations_diff/rule_customizations_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const RuleCustomizationsContext = exports.RuleCustomizationsContext = /*#__PURE__*/(0, _react.createContext)(null);
const RuleCustomizationsContextProvider = ({
  rule,
  children
}) => {
  const {
    ruleCustomizationsFlyout,
    openCustomizationsPreviewFlyout,
    openCustomizationsRevertFlyout,
    doesBaseVersionExist,
    isLoading,
    modifiedFields
  } = (0, _use_rule_customizations_diff.useRuleCustomizationsDiff)({
    rule
  });
  const actions = (0, _react.useMemo)(() => ({
    openCustomizationsPreviewFlyout,
    openCustomizationsRevertFlyout
  }), [openCustomizationsPreviewFlyout, openCustomizationsRevertFlyout]);
  const providerValue = (0, _react.useMemo)(() => ({
    state: {
      isLoading,
      doesBaseVersionExist,
      modifiedFields
    },
    actions
  }), [actions, doesBaseVersionExist, isLoading, modifiedFields]);
  return /*#__PURE__*/_react.default.createElement(RuleCustomizationsContext.Provider, {
    value: providerValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children, ruleCustomizationsFlyout));
};
exports.RuleCustomizationsContextProvider = RuleCustomizationsContextProvider;
const useRuleCustomizationsContext = () => {
  const ruleCustomizationsContext = (0, _react.useContext)(RuleCustomizationsContext);
  (0, _invariant.invariant)(ruleCustomizationsContext, 'useRuleCustomizationsContext should be used inside RuleCustomizationsContextProvider');
  return ruleCustomizationsContext;
};
exports.useRuleCustomizationsContext = useRuleCustomizationsContext;