"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sortAndStringifyJson = exports.getFieldDiffsForTimestampOverride = exports.getFieldDiffsForTimelineTemplate = exports.getFieldDiffsForThreshold = exports.getFieldDiffsForThreatQuery = exports.getFieldDiffsForRuleSchedule = exports.getFieldDiffsForRuleNameOverride = exports.getFieldDiffsForKqlQuery = exports.getFieldDiffsForEsqlQuery = exports.getFieldDiffsForEqlQuery = exports.getFieldDiffsForDataSource = exports.getFieldDiffsForBuildingBlock = void 0;
var _jsonStableStringify = _interopRequireDefault(require("json-stable-stringify"));
var _to_simple_rule_schedule = require("../../../../../../common/api/detection_engine/model/rule_schema/to_simple_rule_schedule");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sortAndStringifyJson = fieldValue => {
  if (!fieldValue) {
    return ''; // The JSON diff package we use does not accept `undefined` as a valid entry, empty string renders the equivalent of no field
  }
  if (typeof fieldValue === 'string') {
    return fieldValue;
  }
  return (0, _jsonStableStringify.default)(fieldValue, {
    space: 2
  });
};
exports.sortAndStringifyJson = sortAndStringifyJson;
const getFieldDiffsForDataSource = dataSourceThreeWayDiff => {
  var _dataSourceThreeWayDi, _dataSourceThreeWayDi2, _dataSourceThreeWayDi3, _dataSourceThreeWayDi4, _dataSourceThreeWayDi5, _dataSourceThreeWayDi6, _dataSourceThreeWayDi7, _dataSourceThreeWayDi8, _dataSourceThreeWayDi9, _dataSourceThreeWayDi10;
  const currentType = sortAndStringifyJson((_dataSourceThreeWayDi = dataSourceThreeWayDiff.current_version) === null || _dataSourceThreeWayDi === void 0 ? void 0 : _dataSourceThreeWayDi.type);
  const targetType = sortAndStringifyJson((_dataSourceThreeWayDi2 = dataSourceThreeWayDiff.target_version) === null || _dataSourceThreeWayDi2 === void 0 ? void 0 : _dataSourceThreeWayDi2.type);
  const currentIndexPatterns = sortAndStringifyJson(((_dataSourceThreeWayDi3 = dataSourceThreeWayDiff.current_version) === null || _dataSourceThreeWayDi3 === void 0 ? void 0 : _dataSourceThreeWayDi3.type) === 'index_patterns' && ((_dataSourceThreeWayDi4 = dataSourceThreeWayDiff.current_version) === null || _dataSourceThreeWayDi4 === void 0 ? void 0 : _dataSourceThreeWayDi4.index_patterns));
  const targetIndexPatterns = sortAndStringifyJson(((_dataSourceThreeWayDi5 = dataSourceThreeWayDiff.target_version) === null || _dataSourceThreeWayDi5 === void 0 ? void 0 : _dataSourceThreeWayDi5.type) === 'index_patterns' && ((_dataSourceThreeWayDi6 = dataSourceThreeWayDiff.target_version) === null || _dataSourceThreeWayDi6 === void 0 ? void 0 : _dataSourceThreeWayDi6.index_patterns));
  const currentDataViewId = sortAndStringifyJson(((_dataSourceThreeWayDi7 = dataSourceThreeWayDiff.current_version) === null || _dataSourceThreeWayDi7 === void 0 ? void 0 : _dataSourceThreeWayDi7.type) === 'data_view' && ((_dataSourceThreeWayDi8 = dataSourceThreeWayDiff.current_version) === null || _dataSourceThreeWayDi8 === void 0 ? void 0 : _dataSourceThreeWayDi8.data_view_id));
  const targetDataViewId = sortAndStringifyJson(((_dataSourceThreeWayDi9 = dataSourceThreeWayDiff.target_version) === null || _dataSourceThreeWayDi9 === void 0 ? void 0 : _dataSourceThreeWayDi9.type) === 'data_view' && ((_dataSourceThreeWayDi10 = dataSourceThreeWayDiff.target_version) === null || _dataSourceThreeWayDi10 === void 0 ? void 0 : _dataSourceThreeWayDi10.data_view_id));
  const hasTypeChanged = currentType !== targetType;
  return [...(hasTypeChanged ? [{
    fieldName: 'type',
    currentVersion: currentType,
    targetVersion: targetType
  }] : []), ...(currentIndexPatterns !== targetIndexPatterns ? [{
    fieldName: 'index_patterns',
    currentVersion: currentIndexPatterns,
    targetVersion: targetIndexPatterns
  }] : []), ...(currentDataViewId !== targetDataViewId ? [{
    fieldName: 'data_view_id',
    currentVersion: currentDataViewId,
    targetVersion: targetDataViewId
  }] : [])];
};
exports.getFieldDiffsForDataSource = getFieldDiffsForDataSource;
const getFieldDiffsForKqlQuery = kqlQueryThreeWayDiff => {
  var _kqlQueryThreeWayDiff, _kqlQueryThreeWayDiff2, _kqlQueryThreeWayDiff3, _kqlQueryThreeWayDiff4, _kqlQueryThreeWayDiff5, _kqlQueryThreeWayDiff6, _kqlQueryThreeWayDiff7, _kqlQueryThreeWayDiff8, _kqlQueryThreeWayDiff9, _kqlQueryThreeWayDiff10, _kqlQueryThreeWayDiff11, _kqlQueryThreeWayDiff12, _kqlQueryThreeWayDiff13, _kqlQueryThreeWayDiff14, _kqlQueryThreeWayDiff15, _kqlQueryThreeWayDiff16, _kqlQueryThreeWayDiff17, _kqlQueryThreeWayDiff18;
  const currentType = sortAndStringifyJson((_kqlQueryThreeWayDiff = kqlQueryThreeWayDiff.current_version) === null || _kqlQueryThreeWayDiff === void 0 ? void 0 : _kqlQueryThreeWayDiff.type);
  const targetType = sortAndStringifyJson((_kqlQueryThreeWayDiff2 = kqlQueryThreeWayDiff.target_version) === null || _kqlQueryThreeWayDiff2 === void 0 ? void 0 : _kqlQueryThreeWayDiff2.type);
  const currentQuery = sortAndStringifyJson(((_kqlQueryThreeWayDiff3 = kqlQueryThreeWayDiff.current_version) === null || _kqlQueryThreeWayDiff3 === void 0 ? void 0 : _kqlQueryThreeWayDiff3.type) === 'inline_query' && ((_kqlQueryThreeWayDiff4 = kqlQueryThreeWayDiff.current_version) === null || _kqlQueryThreeWayDiff4 === void 0 ? void 0 : _kqlQueryThreeWayDiff4.query));
  const targetQuery = sortAndStringifyJson(((_kqlQueryThreeWayDiff5 = kqlQueryThreeWayDiff.target_version) === null || _kqlQueryThreeWayDiff5 === void 0 ? void 0 : _kqlQueryThreeWayDiff5.type) === 'inline_query' && ((_kqlQueryThreeWayDiff6 = kqlQueryThreeWayDiff.target_version) === null || _kqlQueryThreeWayDiff6 === void 0 ? void 0 : _kqlQueryThreeWayDiff6.query));
  const currentLanguage = sortAndStringifyJson(((_kqlQueryThreeWayDiff7 = kqlQueryThreeWayDiff.current_version) === null || _kqlQueryThreeWayDiff7 === void 0 ? void 0 : _kqlQueryThreeWayDiff7.type) === 'inline_query' && ((_kqlQueryThreeWayDiff8 = kqlQueryThreeWayDiff.current_version) === null || _kqlQueryThreeWayDiff8 === void 0 ? void 0 : _kqlQueryThreeWayDiff8.language));
  const targetLanguage = sortAndStringifyJson(((_kqlQueryThreeWayDiff9 = kqlQueryThreeWayDiff.target_version) === null || _kqlQueryThreeWayDiff9 === void 0 ? void 0 : _kqlQueryThreeWayDiff9.type) === 'inline_query' && ((_kqlQueryThreeWayDiff10 = kqlQueryThreeWayDiff.target_version) === null || _kqlQueryThreeWayDiff10 === void 0 ? void 0 : _kqlQueryThreeWayDiff10.language));
  const currentFilters = sortAndStringifyJson(((_kqlQueryThreeWayDiff11 = kqlQueryThreeWayDiff.current_version) === null || _kqlQueryThreeWayDiff11 === void 0 ? void 0 : _kqlQueryThreeWayDiff11.type) === 'inline_query' && ((_kqlQueryThreeWayDiff12 = kqlQueryThreeWayDiff.current_version) === null || _kqlQueryThreeWayDiff12 === void 0 ? void 0 : _kqlQueryThreeWayDiff12.filters));
  const targetFilters = sortAndStringifyJson(((_kqlQueryThreeWayDiff13 = kqlQueryThreeWayDiff.target_version) === null || _kqlQueryThreeWayDiff13 === void 0 ? void 0 : _kqlQueryThreeWayDiff13.type) === 'inline_query' && ((_kqlQueryThreeWayDiff14 = kqlQueryThreeWayDiff.target_version) === null || _kqlQueryThreeWayDiff14 === void 0 ? void 0 : _kqlQueryThreeWayDiff14.filters));
  const currentSavedQueryId = sortAndStringifyJson(((_kqlQueryThreeWayDiff15 = kqlQueryThreeWayDiff.current_version) === null || _kqlQueryThreeWayDiff15 === void 0 ? void 0 : _kqlQueryThreeWayDiff15.type) === 'saved_query' && ((_kqlQueryThreeWayDiff16 = kqlQueryThreeWayDiff.current_version) === null || _kqlQueryThreeWayDiff16 === void 0 ? void 0 : _kqlQueryThreeWayDiff16.saved_query_id));
  const targetSavedQueryId = sortAndStringifyJson(((_kqlQueryThreeWayDiff17 = kqlQueryThreeWayDiff.target_version) === null || _kqlQueryThreeWayDiff17 === void 0 ? void 0 : _kqlQueryThreeWayDiff17.type) === 'saved_query' && ((_kqlQueryThreeWayDiff18 = kqlQueryThreeWayDiff.target_version) === null || _kqlQueryThreeWayDiff18 === void 0 ? void 0 : _kqlQueryThreeWayDiff18.saved_query_id));
  const hasTypeChanged = currentType !== targetType;
  return [...(hasTypeChanged ? [{
    fieldName: 'type',
    currentVersion: currentType,
    targetVersion: targetType
  }] : []), ...(currentQuery !== targetQuery ? [{
    fieldName: 'query',
    currentVersion: currentQuery,
    targetVersion: targetQuery
  }] : []), ...(currentLanguage !== targetLanguage ? [{
    fieldName: 'language',
    currentVersion: currentLanguage,
    targetVersion: targetLanguage
  }] : []), ...(currentFilters !== targetFilters ? [{
    fieldName: 'filters',
    currentVersion: currentFilters,
    targetVersion: targetFilters
  }] : []), ...(currentSavedQueryId !== targetSavedQueryId ? [{
    fieldName: 'saved_query_id',
    currentVersion: currentSavedQueryId,
    targetVersion: targetSavedQueryId
  }] : [])];
};
exports.getFieldDiffsForKqlQuery = getFieldDiffsForKqlQuery;
const getFieldDiffsForEqlQuery = eqlQuery => {
  var _eqlQuery$current_ver, _eqlQuery$target_vers, _eqlQuery$current_ver2, _eqlQuery$target_vers2;
  const currentQuery = sortAndStringifyJson((_eqlQuery$current_ver = eqlQuery.current_version) === null || _eqlQuery$current_ver === void 0 ? void 0 : _eqlQuery$current_ver.query);
  const targetQuery = sortAndStringifyJson((_eqlQuery$target_vers = eqlQuery.target_version) === null || _eqlQuery$target_vers === void 0 ? void 0 : _eqlQuery$target_vers.query);
  const currentFilters = sortAndStringifyJson((_eqlQuery$current_ver2 = eqlQuery.current_version) === null || _eqlQuery$current_ver2 === void 0 ? void 0 : _eqlQuery$current_ver2.filters);
  const targetFilters = sortAndStringifyJson((_eqlQuery$target_vers2 = eqlQuery.target_version) === null || _eqlQuery$target_vers2 === void 0 ? void 0 : _eqlQuery$target_vers2.filters);
  return [...(currentQuery !== targetQuery ? [{
    fieldName: 'query',
    currentVersion: currentQuery,
    targetVersion: targetQuery
  }] : []), ...(currentFilters !== targetFilters ? [{
    fieldName: 'filters',
    currentVersion: currentFilters,
    targetVersion: targetFilters
  }] : [])];
};
exports.getFieldDiffsForEqlQuery = getFieldDiffsForEqlQuery;
const getFieldDiffsForEsqlQuery = esqlQuery => {
  var _esqlQuery$current_ve, _esqlQuery$target_ver, _esqlQuery$current_ve2, _esqlQuery$target_ver2;
  const currentQuery = sortAndStringifyJson((_esqlQuery$current_ve = esqlQuery.current_version) === null || _esqlQuery$current_ve === void 0 ? void 0 : _esqlQuery$current_ve.query);
  const targetQuery = sortAndStringifyJson((_esqlQuery$target_ver = esqlQuery.target_version) === null || _esqlQuery$target_ver === void 0 ? void 0 : _esqlQuery$target_ver.query);
  const currentLanguage = sortAndStringifyJson((_esqlQuery$current_ve2 = esqlQuery.current_version) === null || _esqlQuery$current_ve2 === void 0 ? void 0 : _esqlQuery$current_ve2.language);
  const targetLanguage = sortAndStringifyJson((_esqlQuery$target_ver2 = esqlQuery.target_version) === null || _esqlQuery$target_ver2 === void 0 ? void 0 : _esqlQuery$target_ver2.language);
  return [...(currentQuery !== targetQuery ? [{
    fieldName: 'query',
    currentVersion: currentQuery,
    targetVersion: targetQuery
  }] : []), ...(currentLanguage !== targetLanguage ? [{
    fieldName: 'language',
    currentVersion: currentLanguage,
    targetVersion: targetLanguage
  }] : [])];
};
exports.getFieldDiffsForEsqlQuery = getFieldDiffsForEsqlQuery;
const getFieldDiffsForThreatQuery = threatQuery => {
  var _threatQuery$current_, _threatQuery$target_v, _threatQuery$current_2, _threatQuery$target_v2, _threatQuery$current_3, _threatQuery$target_v3;
  const currentQuery = sortAndStringifyJson((_threatQuery$current_ = threatQuery.current_version) === null || _threatQuery$current_ === void 0 ? void 0 : _threatQuery$current_.query);
  const targetQuery = sortAndStringifyJson((_threatQuery$target_v = threatQuery.target_version) === null || _threatQuery$target_v === void 0 ? void 0 : _threatQuery$target_v.query);
  const currentLanguage = sortAndStringifyJson((_threatQuery$current_2 = threatQuery.current_version) === null || _threatQuery$current_2 === void 0 ? void 0 : _threatQuery$current_2.language);
  const targetLanguage = sortAndStringifyJson((_threatQuery$target_v2 = threatQuery.target_version) === null || _threatQuery$target_v2 === void 0 ? void 0 : _threatQuery$target_v2.language);
  const currentFilters = sortAndStringifyJson((_threatQuery$current_3 = threatQuery.current_version) === null || _threatQuery$current_3 === void 0 ? void 0 : _threatQuery$current_3.filters);
  const targetFilters = sortAndStringifyJson((_threatQuery$target_v3 = threatQuery.target_version) === null || _threatQuery$target_v3 === void 0 ? void 0 : _threatQuery$target_v3.filters);
  return [...(currentQuery !== targetQuery ? [{
    fieldName: 'query',
    currentVersion: currentQuery,
    targetVersion: targetQuery
  }] : []), ...(currentLanguage !== targetLanguage ? [{
    fieldName: 'language',
    currentVersion: currentLanguage,
    targetVersion: targetLanguage
  }] : []), ...(currentFilters !== targetFilters ? [{
    fieldName: 'filters',
    currentVersion: currentFilters,
    targetVersion: targetFilters
  }] : [])];
};
exports.getFieldDiffsForThreatQuery = getFieldDiffsForThreatQuery;
const getFieldDiffsForRuleSchedule = ruleScheduleThreeWayDiff => {
  const fieldsDiff = [];
  const current = ruleScheduleThreeWayDiff.current_version;
  const target = ruleScheduleThreeWayDiff.target_version;
  const currentSimpleRuleSchedule = current ? (0, _to_simple_rule_schedule.toSimpleRuleSchedule)(current) : undefined;
  const targetSimpleRuleSchedule = target ? (0, _to_simple_rule_schedule.toSimpleRuleSchedule)(target) : undefined;
  const isCurrentSimpleRuleScheduleValid = !current || current && currentSimpleRuleSchedule;
  const isTargetSimpleRuleScheduleValid = !target || target && targetSimpleRuleSchedule;

  // Show simple rule schedule diff only when current and target versions are convertable
  // to simple rule schedule or one of the versions is undefined.
  if (isCurrentSimpleRuleScheduleValid && isTargetSimpleRuleScheduleValid) {
    return getFieldDiffsForSimpleRuleSchedule(currentSimpleRuleSchedule, targetSimpleRuleSchedule);
  }
  if ((current === null || current === void 0 ? void 0 : current.interval) !== (target === null || target === void 0 ? void 0 : target.interval)) {
    fieldsDiff.push({
      fieldName: 'interval',
      currentVersion: sortAndStringifyJson(current === null || current === void 0 ? void 0 : current.interval),
      targetVersion: sortAndStringifyJson(target === null || target === void 0 ? void 0 : target.interval)
    });
  }
  if ((current === null || current === void 0 ? void 0 : current.from) !== (target === null || target === void 0 ? void 0 : target.from)) {
    fieldsDiff.push({
      fieldName: 'from',
      currentVersion: sortAndStringifyJson(current === null || current === void 0 ? void 0 : current.from),
      targetVersion: sortAndStringifyJson(target === null || target === void 0 ? void 0 : target.from)
    });
  }
  if ((current === null || current === void 0 ? void 0 : current.to) !== (target === null || target === void 0 ? void 0 : target.to)) {
    fieldsDiff.push({
      fieldName: 'to',
      currentVersion: sortAndStringifyJson(current === null || current === void 0 ? void 0 : current.to),
      targetVersion: sortAndStringifyJson(target === null || target === void 0 ? void 0 : target.to)
    });
  }
  return fieldsDiff;
};
exports.getFieldDiffsForRuleSchedule = getFieldDiffsForRuleSchedule;
const getFieldDiffsForSimpleRuleSchedule = (current, target) => {
  const fieldsDiff = [];
  if ((current === null || current === void 0 ? void 0 : current.interval) !== (target === null || target === void 0 ? void 0 : target.interval)) {
    fieldsDiff.push({
      fieldName: 'interval',
      currentVersion: sortAndStringifyJson(current === null || current === void 0 ? void 0 : current.interval),
      targetVersion: sortAndStringifyJson(target === null || target === void 0 ? void 0 : target.interval)
    });
  }
  if ((current === null || current === void 0 ? void 0 : current.lookback) !== (target === null || target === void 0 ? void 0 : target.lookback)) {
    fieldsDiff.push({
      fieldName: 'lookback',
      currentVersion: sortAndStringifyJson(current === null || current === void 0 ? void 0 : current.lookback),
      targetVersion: sortAndStringifyJson(target === null || target === void 0 ? void 0 : target.lookback)
    });
  }
  return fieldsDiff;
};
const getFieldDiffsForRuleNameOverride = ruleNameOverrideThreeWayDiff => {
  var _ruleNameOverrideThre, _ruleNameOverrideThre2;
  const currentFieldName = sortAndStringifyJson((_ruleNameOverrideThre = ruleNameOverrideThreeWayDiff.current_version) === null || _ruleNameOverrideThre === void 0 ? void 0 : _ruleNameOverrideThre.field_name);
  const targetFieldName = sortAndStringifyJson((_ruleNameOverrideThre2 = ruleNameOverrideThreeWayDiff.target_version) === null || _ruleNameOverrideThre2 === void 0 ? void 0 : _ruleNameOverrideThre2.field_name);
  return [...(currentFieldName !== targetFieldName ? [{
    fieldName: 'field_name',
    currentVersion: currentFieldName,
    targetVersion: targetFieldName
  }] : [])];
};
exports.getFieldDiffsForRuleNameOverride = getFieldDiffsForRuleNameOverride;
const getFieldDiffsForTimestampOverride = timestampOverrideThreeWayDiff => {
  var _timestampOverrideThr, _timestampOverrideThr2, _timestampOverrideThr3, _timestampOverrideThr4;
  const currentFieldName = sortAndStringifyJson((_timestampOverrideThr = timestampOverrideThreeWayDiff.current_version) === null || _timestampOverrideThr === void 0 ? void 0 : _timestampOverrideThr.field_name);
  const targetFieldName = sortAndStringifyJson((_timestampOverrideThr2 = timestampOverrideThreeWayDiff.target_version) === null || _timestampOverrideThr2 === void 0 ? void 0 : _timestampOverrideThr2.field_name);
  const currentVersionFallbackDisabled = sortAndStringifyJson((_timestampOverrideThr3 = timestampOverrideThreeWayDiff.current_version) === null || _timestampOverrideThr3 === void 0 ? void 0 : _timestampOverrideThr3.fallback_disabled);
  const targetVersionFallbackDisabled = sortAndStringifyJson((_timestampOverrideThr4 = timestampOverrideThreeWayDiff.target_version) === null || _timestampOverrideThr4 === void 0 ? void 0 : _timestampOverrideThr4.fallback_disabled);
  return [...(currentFieldName !== targetFieldName ? [{
    fieldName: 'field_name',
    currentVersion: currentFieldName,
    targetVersion: targetFieldName
  }] : []), ...(currentVersionFallbackDisabled !== targetVersionFallbackDisabled ? [{
    fieldName: 'fallback_disabled',
    currentVersion: currentVersionFallbackDisabled,
    targetVersion: targetVersionFallbackDisabled
  }] : [])];
};
exports.getFieldDiffsForTimestampOverride = getFieldDiffsForTimestampOverride;
const getFieldDiffsForTimelineTemplate = timelineTemplateThreeWayDiff => {
  var _timelineTemplateThre, _timelineTemplateThre2, _timelineTemplateThre3, _timelineTemplateThre4;
  const currentTimelineId = sortAndStringifyJson((_timelineTemplateThre = timelineTemplateThreeWayDiff.current_version) === null || _timelineTemplateThre === void 0 ? void 0 : _timelineTemplateThre.timeline_id);
  const targetTimelineId = sortAndStringifyJson((_timelineTemplateThre2 = timelineTemplateThreeWayDiff.target_version) === null || _timelineTemplateThre2 === void 0 ? void 0 : _timelineTemplateThre2.timeline_id);
  const currentTimelineTitle = sortAndStringifyJson((_timelineTemplateThre3 = timelineTemplateThreeWayDiff.current_version) === null || _timelineTemplateThre3 === void 0 ? void 0 : _timelineTemplateThre3.timeline_title);
  const targetTimelineTitle = sortAndStringifyJson((_timelineTemplateThre4 = timelineTemplateThreeWayDiff.target_version) === null || _timelineTemplateThre4 === void 0 ? void 0 : _timelineTemplateThre4.timeline_title);
  return [...(currentTimelineId !== targetTimelineId ? [{
    fieldName: 'timeline_id',
    currentVersion: currentTimelineId,
    targetVersion: targetTimelineId
  }] : []), ...(currentTimelineTitle !== targetTimelineTitle ? [{
    fieldName: 'timeline_title',
    currentVersion: currentTimelineTitle,
    targetVersion: targetTimelineTitle
  }] : [])];
};
exports.getFieldDiffsForTimelineTemplate = getFieldDiffsForTimelineTemplate;
const getFieldDiffsForBuildingBlock = buildingBlockThreeWayDiff => {
  var _buildingBlockThreeWa, _buildingBlockThreeWa2;
  const currentType = sortAndStringifyJson((_buildingBlockThreeWa = buildingBlockThreeWayDiff.current_version) === null || _buildingBlockThreeWa === void 0 ? void 0 : _buildingBlockThreeWa.type);
  const targetType = sortAndStringifyJson((_buildingBlockThreeWa2 = buildingBlockThreeWayDiff.target_version) === null || _buildingBlockThreeWa2 === void 0 ? void 0 : _buildingBlockThreeWa2.type);
  return [...(currentType !== targetType ? [{
    fieldName: 'type',
    currentVersion: currentType,
    targetVersion: targetType
  }] : [])];
};
exports.getFieldDiffsForBuildingBlock = getFieldDiffsForBuildingBlock;
const getFieldDiffsForThreshold = thresholdThreeWayDiff => {
  var _thresholdThreeWayDif, _thresholdThreeWayDif2, _thresholdThreeWayDif3, _thresholdThreeWayDif4, _thresholdThreeWayDif5, _thresholdThreeWayDif6;
  const currentField = sortAndStringifyJson((_thresholdThreeWayDif = thresholdThreeWayDiff.current_version) === null || _thresholdThreeWayDif === void 0 ? void 0 : _thresholdThreeWayDif.field);
  const targetField = sortAndStringifyJson((_thresholdThreeWayDif2 = thresholdThreeWayDiff.target_version) === null || _thresholdThreeWayDif2 === void 0 ? void 0 : _thresholdThreeWayDif2.field);
  const currentValue = sortAndStringifyJson((_thresholdThreeWayDif3 = thresholdThreeWayDiff.current_version) === null || _thresholdThreeWayDif3 === void 0 ? void 0 : _thresholdThreeWayDif3.value);
  const targetValue = sortAndStringifyJson((_thresholdThreeWayDif4 = thresholdThreeWayDiff.target_version) === null || _thresholdThreeWayDif4 === void 0 ? void 0 : _thresholdThreeWayDif4.value);
  const currentCardinality = sortAndStringifyJson((_thresholdThreeWayDif5 = thresholdThreeWayDiff.current_version) === null || _thresholdThreeWayDif5 === void 0 ? void 0 : _thresholdThreeWayDif5.cardinality);
  const targetCardinality = sortAndStringifyJson((_thresholdThreeWayDif6 = thresholdThreeWayDiff.target_version) === null || _thresholdThreeWayDif6 === void 0 ? void 0 : _thresholdThreeWayDif6.cardinality);
  return [...(currentField !== targetField ? [{
    fieldName: 'field',
    currentVersion: currentField,
    targetVersion: targetField
  }] : []), ...(currentValue !== targetValue ? [{
    fieldName: 'value',
    currentVersion: currentValue,
    targetVersion: targetValue
  }] : []), ...(currentCardinality !== targetCardinality ? [{
    fieldName: 'cardinality',
    currentVersion: currentCardinality,
    targetVersion: targetCardinality
  }] : [])];
};
exports.getFieldDiffsForThreshold = getFieldDiffsForThreshold;