"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThresholdAlertSuppressionEdit = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _components = require("@kbn/es-ui-shared-plugin/static/forms/components");
var _shared_imports = require("../../../../shared_imports");
var _fields = require("./fields");
var _alert_suppression_edit = require("../alert_suppression_edit");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/threshold_alert_suppression_edit/threshold_alert_suppression_edit.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ThresholdAlertSuppressionEdit = exports.ThresholdAlertSuppressionEdit = /*#__PURE__*/(0, _react.memo)(function ThresholdAlertSuppressionEdit({
  suppressionFieldNames,
  disabled,
  disabledText
}) {
  const [{
    [_fields.THRESHOLD_ALERT_SUPPRESSION_ENABLED]: suppressionEnabled
  }] = (0, _shared_imports.useFormData)({
    watch: _fields.THRESHOLD_ALERT_SUPPRESSION_ENABLED
  });
  const content = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: _fields.THRESHOLD_ALERT_SUPPRESSION_ENABLED,
    component: _components.CheckBoxField,
    componentProps: {
      idAria: 'thresholdAlertSuppressionEnabled',
      'data-test-subj': 'thresholdAlertSuppressionEnabled'
    },
    euiFieldProps: {
      label: suppressionFieldNames !== null && suppressionFieldNames !== void 0 && suppressionFieldNames.length ? i18n.enableSuppressionForFields(suppressionFieldNames) : i18n.SUPPRESS_ALERTS,
      disabled
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    hasShadow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_alert_suppression_edit.SuppressionDurationSelector, {
    onlyPerTimePeriod: true,
    onlyPerTimePeriodReasonMessage: i18n.THRESHOLD_SUPPRESSION_PER_RULE_EXECUTION_WARNING,
    disabled: !suppressionEnabled || disabled,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 9
    }
  })));
  return disabled && disabledText ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    position: "right",
    content: disabledText,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, content) : content;
});