"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlAdminJobDescription = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_enable_data_feed = require("../../../../../common/components/ml_popover/hooks/use_enable_data_feed");
var _job_switch = require("../../../../../common/components/ml_popover/jobs_table/job_switch");
var _ml_job_item = require("../ml_job_item");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/detection_engine/rule_creation/components/ml_jobs_description/admin/ml_admin_job_description.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MlAdminJobDescriptionComponent = ({
  job,
  loading,
  refreshJob
}) => {
  const {
    enableDatafeed,
    disableDatafeed,
    isLoading: isLoadingEnableDataFeed
  } = (0, _use_enable_data_feed.useEnableDataFeed)();
  const handleJobStateChange = (0, _react.useCallback)(async (_, latestTimestampMs, enable) => {
    if (enable) {
      await enableDatafeed(job, latestTimestampMs);
    } else {
      await disableDatafeed(job);
    }
    refreshJob(job);
  }, [enableDatafeed, disableDatafeed, job, refreshJob]);
  const switchComponent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_job_switch.JobSwitch, {
    job: job,
    isSecurityJobsLoading: loading || isLoadingEnableDataFeed,
    onJobStateChange: handleJobStateChange,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 50,
      columnNumber: 7
    }
  }), [handleJobStateChange, isLoadingEnableDataFeed, job, loading]);
  return /*#__PURE__*/_react.default.createElement(_ml_job_item.MlJobItem, {
    job: job,
    switchComponent: switchComponent,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 10
    }
  });
};
const MlAdminJobDescription = exports.MlAdminJobDescription = /*#__PURE__*/(0, _react.memo)(MlAdminJobDescriptionComponent);