"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSecurityDefaultPatterns = void 0;
var _react = require("react");
var _reactRedux = require("react-redux");
var _selectors = require("../redux/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const emptyArray = [];

/**
 * Returns the default data view id and index patterns.
 */
const useSecurityDefaultPatterns = () => {
  const {
    dataViews: dataViewSpecs,
    defaultDataViewId
  } = (0, _reactRedux.useSelector)(_selectors.sharedStateSelector);
  const defaultDataViewSpec = (0, _react.useMemo)(() => dataViewSpecs.find(dv => dv.id === defaultDataViewId), [dataViewSpecs, defaultDataViewId]);
  return (0, _react.useMemo)(() => {
    var _defaultDataViewSpec$, _defaultDataViewSpec$2, _defaultDataViewSpec$3;
    return {
      id: (_defaultDataViewSpec$ = defaultDataViewSpec === null || defaultDataViewSpec === void 0 ? void 0 : defaultDataViewSpec.id) !== null && _defaultDataViewSpec$ !== void 0 ? _defaultDataViewSpec$ : '',
      indexPatterns: (_defaultDataViewSpec$2 = defaultDataViewSpec === null || defaultDataViewSpec === void 0 ? void 0 : (_defaultDataViewSpec$3 = defaultDataViewSpec.title) === null || _defaultDataViewSpec$3 === void 0 ? void 0 : _defaultDataViewSpec$3.split(',')) !== null && _defaultDataViewSpec$2 !== void 0 ? _defaultDataViewSpec$2 : emptyArray
    };
  }, [defaultDataViewSpec]);
};
exports.useSecurityDefaultPatterns = useSecurityDefaultPatterns;