"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useErrorToast = void 0;
var _react = require("react");
var _use_app_toasts = require("./use_app_toasts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Display App error toast when error is defined.
 */
const useErrorToast = (title, error) => {
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  (0, _react.useEffect)(() => {
    if (error) {
      addError(error, {
        title
      });
    }
  }, [error, title, addError]);
};
exports.useErrorToast = useErrorToast;