"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHasRiskScore = void 0;
var _react = require("react");
var _search_strategy = require("../../../common/search_strategy");
var _use_risk_score = require("../../entity_analytics/api/hooks/use_risk_score");
var _common = require("../../entity_analytics/common");
var _types = require("../../../common/entity_analytics/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHasRiskScore = ({
  field,
  value
}) => {
  const isHostNameField = field === 'host.name';
  const buildFilterQuery = (0, _react.useMemo)(() => isHostNameField ? (0, _search_strategy.buildHostNamesFilter)([value]) : (0, _search_strategy.buildUserNamesFilter)([value]), [isHostNameField, value]);
  const {
    data
  } = (0, _use_risk_score.useRiskScore)({
    riskEntity: isHostNameField ? _types.EntityType.host : _types.EntityType.user,
    filterQuery: buildFilterQuery,
    onlyLatest: false,
    pagination: _common.FIRST_RECORD_PAGINATION
  });
  const riskData = data === null || data === void 0 ? void 0 : data[0];
  const hasRiskScore = isHostNameField ? !!(riskData !== null && riskData !== void 0 && riskData.host.risk) : !!(riskData !== null && riskData !== void 0 && riskData.user.risk);
  return {
    hasRiskScore
  };
};
exports.useHasRiskScore = useHasRiskScore;