"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createLaunchpadNavigationTree = void 0;
var _constants = require("../constants");
var _link_groups = require("../link_groups");
var _links = require("../links");
var _i18n_strings = require("../i18n_strings");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createLaunchpadNavigationTree = (options = {}) => {
  const {
    hasAiValueAccess = false,
    sideNavVersion = 'v1'
  } = options;
  const children = [{
    id: _constants.SecurityPageName.landing,
    link: (0, _links.securityLink)(_constants.SecurityPageName.landing),
    renderAs: 'item'
  }];

  // Add AI Value link only if user has access
  if (hasAiValueAccess) {
    children.push({
      id: _constants.SecurityPageName.aiValue,
      link: (0, _links.securityLink)(_constants.SecurityPageName.aiValue),
      renderAs: 'item'
    });
  }

  // If user doesn't have AI Value access, return just the landing page item
  if (!hasAiValueAccess) {
    return {
      id: _constants.SecurityPageName.landing,
      link: (0, _links.securityLink)(_constants.SecurityPageName.landing),
      renderAs: 'item',
      icon: 'launch',
      iconV2: 'launch',
      sideNavVersion: 'v1'
    };
  }

  // If user has AI Value access, return the full panel opener
  return {
    id: _constants.SecurityGroupName.launchpad,
    title: sideNavVersion === 'v2' ? _i18n_strings.i18nStrings.launchPad.title : _link_groups.SecurityLinkGroup[_constants.SecurityGroupName.launchpad].title,
    renderAs: 'panelOpener',
    icon: 'launch',
    iconV2: 'launch',
    sideNavVersion,
    children: [{
      children
    }]
  };
};
exports.createLaunchpadNavigationTree = createLaunchpadNavigationTree;