"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LandingLinksImageCard = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _links = require("../links");
var _beta_badge = require("./beta_badge");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/packages/navigation/src/landing_links/landing_links_image_card.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CARD_HEIGHT = 116;
const CARD_WIDTH = 370;
const CARD_HEIGHT_IMAGE = 98;
const useStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    card: (0, _react2.css)`
      height: ${CARD_HEIGHT}px;
      max-width: ${CARD_WIDTH}px;
    `,
    cardWrapper: (0, _react2.css)`
      height: 100%;
    `,
    titleContainer: (0, _react2.css)`
      height: ${euiTheme.size.l};
    `,
    title: (0, _react2.css)`
      color: ${euiTheme.colors.primaryText};
      font-weight: ${euiTheme.font.weight.semiBold};
    `,
    getImageContainer: imageUrl => (0, _react2.css)`
      height: ${CARD_HEIGHT_IMAGE}px;
      width: ${CARD_HEIGHT_IMAGE}px;
      background-position: center center;
      background-repeat: no-repeat;
      background-image: url(${imageUrl !== null && imageUrl !== void 0 ? imageUrl : ''});
      background-size: auto 98px;
    `
  };
};
const EuiPanelWithLink = (0, _links.withLink)(_eui.EuiPanel);
const LandingLinksImageCard = exports.LandingLinksImageCard = /*#__PURE__*/_react.default.memo(function LandingLinksImageCard({
  item,
  urlState,
  onLinkClick
}) {
  const styles = useStyles();
  const linkProps = (0, _utils.getKibanaLinkProps)({
    item,
    urlState,
    onLinkClick
  });
  const {
    landingImage,
    title,
    description,
    isBeta,
    betaOptions
  } = item;
  const imageBackground = (0, _react.useMemo)(() => styles.getImageContainer(landingImage), [landingImage, styles]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "LandingImageCard-item",
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(EuiPanelWithLink, (0, _extends2.default)({}, linkProps, {
    hasBorder: true,
    paddingSize: "s",
    css: styles.card,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "row",
    justifyContent: "flexStart",
    alignItems: "flexStart",
    css: styles.cardWrapper,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 13
    }
  }, landingImage && /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": "LandingImageCard-image",
    paddingSize: "none",
    hasShadow: false,
    hasBorder: true,
    borderRadius: "m",
    css: imageBackground,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "row",
    css: styles.titleContainer,
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    component: "span",
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxxs",
    css: styles.title,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 25
    }
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 21
    }
  }, isBeta && /*#__PURE__*/_react.default.createElement(_beta_badge.BetaBadge, {
    text: betaOptions === null || betaOptions === void 0 ? void 0 : betaOptions.text,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 45
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 19
    }
  }, description)))))));
});

// eslint-disable-next-line import/no-default-export
var _default = exports.default = LandingLinksImageCard;