"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleGroupTitle = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _model = require("../../model");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/role_mappings/edit_role_mapping/rule_editor_panel/rule_group_title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const rules = [new _model.AllRule(), new _model.AnyRule()];
const exceptRules = [new _model.ExceptAllRule(), new _model.ExceptAnyRule()];
const RuleGroupTitle = props => {
  var _props$readOnly;
  const readOnly = (_props$readOnly = props.readOnly) !== null && _props$readOnly !== void 0 ? _props$readOnly : false;
  const [isMenuOpen, setIsMenuOpen] = (0, _react.useState)(false);
  const [showConfirmChangeModal, setShowConfirmChangeModal] = (0, _react.useState)(false);
  const [pendingNewRule, setPendingNewRule] = (0, _react.useState)(null);
  const canUseExcept = props.parentRule && props.parentRule.canContainRules(exceptRules);
  const availableRuleTypes = [...rules, ...(canUseExcept ? exceptRules : [])];
  const onChange = newRule => {
    const currentSubRules = props.rule.getRules();
    const areSubRulesValid = newRule.canContainRules(currentSubRules);
    if (areSubRulesValid) {
      const clone = newRule.clone();
      currentSubRules.forEach(subRule => clone.addRule(subRule));
      props.onChange(clone);
      setIsMenuOpen(false);
    } else {
      setPendingNewRule(newRule);
      setShowConfirmChangeModal(true);
    }
  };
  const changeRuleDiscardingSubRules = newRule => {
    // Ensure a default sub rule is present when not carrying over the original sub rules
    const newRuleInstance = newRule.clone();
    if (newRuleInstance.getRules().length === 0) {
      newRuleInstance.addRule(new _model.FieldRule('username', '*'));
    }
    props.onChange(newRuleInstance);
    setIsMenuOpen(false);
  };
  const ruleButton = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    disabled: readOnly,
    onClick: () => setIsMenuOpen(!isMenuOpen),
    "data-test-subj": "ruleGroupTitle",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, props.rule.getDisplayTitle(), readOnly === false && /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "arrowDown",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 30
    }
  }));
  const ruleTypeSelector = /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: ruleButton,
    isOpen: isMenuOpen,
    closePopover: () => setIsMenuOpen(false),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: availableRuleTypes.map((rt, index) => {
      const isSelected = rt.getDisplayTitle() === props.rule.getDisplayTitle();
      const icon = isSelected ? 'check' : 'empty';
      return /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: index,
        icon: icon,
        onClick: () => onChange(rt),
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 13
        }
      }, rt.getDisplayTitle());
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 7
    }
  }));
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  const confirmChangeModal = showConfirmChangeModal ? /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "data-test-subj": "confirmRuleChangeModal",
    "aria-labelledby": modalTitleId,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRoleMapping.confirmGroupChangePromptTitle",
      defaultMessage: "Change group type?",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 9
      }
    }),
    titleProps: {
      id: modalTitleId
    },
    onCancel: () => {
      setShowConfirmChangeModal(false);
      setPendingNewRule(null);
    },
    onConfirm: () => {
      setShowConfirmChangeModal(false);
      changeRuleDiscardingSubRules(pendingNewRule);
      setPendingNewRule(null);
    },
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRoleMapping.confirmGroupChangeCancelButton",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 122,
        columnNumber: 9
      }
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRoleMapping.confirmGroupChangeConfirmButton",
      defaultMessage: "Change anyway",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.management.editRoleMapping.switchWithIncompatibleRulesMessage",
    defaultMessage: "This group contains rules that are not compatible with the new type. If you change types, you will lose all rules within this group.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }))) : null;
  return /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 5
    }
  }, ruleTypeSelector, confirmChangeModal);
};
exports.RuleGroupTitle = RuleGroupTitle;