"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cancelSyncs = void 0;
var _std = require("@kbn/std");
var _ = require("..");
var _connectors = require("../types/connectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const cancelSyncs = async (client, connectorId) => {
  await (0, _std.asyncForEach)([_connectors.SyncStatus.PENDING, _connectors.SyncStatus.IN_PROGRESS, _connectors.SyncStatus.SUSPENDED], async status => {
    const syncJobsToCancel = await (0, _.fetchSyncJobs)(client, connectorId, 0, 1000, 'all', status);
    await (0, _std.asyncForEach)(syncJobsToCancel.data, async syncJob => {
      await (0, _.cancelSync)(client, syncJob.id);
    });
  });
  return await client.transport.request({
    method: 'PUT',
    path: `/_connector/${connectorId}/_last_sync`,
    body: {
      last_access_control_sync_status: _connectors.SyncStatus.CANCELED,
      last_sync_status: _connectors.SyncStatus.CANCELED
    }
  });
};
exports.cancelSyncs = cancelSyncs;