"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addCluster = addCluster;
var _action_types = require("../action_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialState = {
  isAdding: false,
  error: undefined
};
function addCluster(state = initialState, action) {
  const {
    type,
    payload
  } = action;
  switch (type) {
    case _action_types.ADD_CLUSTER_START:
      return {
        isAdding: true,
        error: undefined
      };
    case _action_types.ADD_CLUSTER_SUCCESS:
      return {
        ...state,
        isAdding: false
      };
    case _action_types.ADD_CLUSTER_FAILURE:
      return {
        ...state,
        error: payload.error,
        isAdding: false
      };
    case _action_types.CLEAR_ADD_CLUSTER_ERRORS:
      return {
        ...state,
        error: undefined
      };
    default:
      return state;
  }
}