"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NavigationButtons = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _common = require("../../common");
var _kibana = require("../common/lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/osquery/public/fleet_integration/navigation_buttons.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const NavigationButtonsComponent = ({
  isDisabled = false,
  agentPolicyIds
}) => {
  const {
    application: {
      getUrlForApp,
      navigateToApp
    }
  } = (0, _kibana.useKibana)().services;
  const agentPolicyIdsQueryParam = (0, _react.useMemo)(() => agentPolicyIds === null || agentPolicyIds === void 0 ? void 0 : agentPolicyIds.map(id => `agentPolicyId=${id}`).join('&'), [agentPolicyIds]);
  const liveQueryHref = (0, _react.useMemo)(() => getUrlForApp(_common.PLUGIN_ID, {
    path: agentPolicyIds !== null && agentPolicyIds !== void 0 && agentPolicyIds.length ? `/live_queries/new?${agentPolicyIdsQueryParam}` : '/live_queries/new'
  }), [agentPolicyIdsQueryParam, agentPolicyIds === null || agentPolicyIds === void 0 ? void 0 : agentPolicyIds.length, getUrlForApp]);
  const liveQueryClick = (0, _react.useCallback)(event => {
    if (!(0, _kibana.isModifiedEvent)(event) && (0, _kibana.isLeftClickEvent)(event)) {
      event.preventDefault();
      navigateToApp(_common.PLUGIN_ID, {
        path: agentPolicyIds !== null && agentPolicyIds !== void 0 && agentPolicyIds.length ? `/live_queries/new?${agentPolicyIdsQueryParam}` : '/live_queries/new'
      });
    }
  }, [agentPolicyIdsQueryParam, agentPolicyIds === null || agentPolicyIds === void 0 ? void 0 : agentPolicyIds.length, navigateToApp]);
  const packsHref = getUrlForApp(_common.PLUGIN_ID, {
    path: `/packs`
  });
  const packsClick = (0, _react.useCallback)(event => {
    if (!(0, _kibana.isModifiedEvent)(event) && (0, _kibana.isLeftClickEvent)(event)) {
      event.preventDefault();
      navigateToApp(_common.PLUGIN_ID, {
        path: `/packs`
      });
    }
  }, [navigateToApp]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: "console",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 17
      }
    }),
    title: _i18n.i18n.translate('xpack.osquery.fleetIntegration.runLiveQueriesButtonText', {
      defaultMessage: 'Run live queries'
    }),
    href: liveQueryHref,
    onClick: liveQueryClick,
    description: '',
    isDisabled: isDisabled,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: "clock",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 17
      }
    }),
    title: _i18n.i18n.translate('xpack.osquery.fleetIntegration.packsButtonText', {
      defaultMessage: 'Packs'
    }),
    description: '',
    isDisabled: isDisabled,
    href: packsHref,
    onClick: packsClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  })));
};
NavigationButtonsComponent.displayName = 'NavigationButtonsComponent';
const NavigationButtons = exports.NavigationButtons = /*#__PURE__*/_react.default.memo(NavigationButtonsComponent);