"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ungrouped = exports.source = exports.ruleName = exports.DEFAULT_GROUPING_OPTIONS = void 0;
var _i18n = require("@kbn/i18n");
var _ruleDataUtils = require("@kbn/rule-data-utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ungrouped = exports.ungrouped = _i18n.i18n.translate('xpack.observability.alert.grouping.ungrouped.label', {
  defaultMessage: 'Ungrouped'
});
const ruleName = exports.ruleName = _i18n.i18n.translate('xpack.observability.alert.grouping.ruleName.label', {
  defaultMessage: 'Rule name'
});
const source = exports.source = _i18n.i18n.translate('xpack.observability.alert.grouping.source.label', {
  defaultMessage: 'Source'
});
const DEFAULT_GROUPING_OPTIONS = exports.DEFAULT_GROUPING_OPTIONS = [{
  label: ruleName,
  key: _ruleDataUtils.ALERT_RULE_NAME
}, {
  label: source,
  key: _ruleDataUtils.ALERT_INSTANCE_ID
}];