"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InsightBase = InsightBase;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/observability_ai_assistant/public/components/insight/insight_base.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function InsightBase({
  title,
  description = _i18n.i18n.translate('xpack.observabilityAiAssistant.insight.defaultDescription', {
    defaultMessage: 'Get helpful insights from our Elastic AI Assistant.'
  }),
  controls,
  children,
  actions,
  onToggle,
  loading,
  isOpen,
  dataTestSubj = 'obsAiAssistantInsightButton'
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isActionsPopoverOpen, setIsActionsPopover] = (0, _react.useState)(false);
  const handleClickActions = () => {
    setIsActionsPopover(!isActionsPopoverOpen);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 61,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
    id: "obsAiAssistantInsightContainer",
    arrowProps: {
      css: {
        alignSelf: 'flex-start'
      }
    },
    buttonContent: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      responsive: false,
      gutterSize: "m",
      "data-test-subj": dataTestSubj,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 66,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_aiAssistantIcon.AssistantIcon, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      css: {
        marginTop: 2,
        marginBottom: 1
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 73,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 19
      }
    }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: _i18n.i18n.translate('xpack.observabilityAiAssistant.insight.iconTooltip', {
        defaultMessage: 'Every contextual insight can be changed with a custom prompt defined by the user. You can always reset it to the default.'
      }),
      position: "right",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      css: {
        color: euiTheme.colors.textSubdued
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 85,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 17
      }
    }, description)))),
    isLoading: loading,
    isDisabled: loading,
    forceState: isOpen ? 'open' : 'closed',
    extraAction: actions !== null && actions !== void 0 && actions.length || controls ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s",
      responsive: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 13
      }
    }, controls && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 28
      }
    }, controls), actions !== null && actions !== void 0 && actions.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      anchorPosition: "downLeft",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
        "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.insight.actions', {
          defaultMessage: 'Actions'
        }),
        color: "text",
        css: {
          alignSelf: 'flex-start'
        },
        "data-test-subj": "observabilityAiAssistantInsightBaseButtonIcon",
        disabled: (actions === null || actions === void 0 ? void 0 : actions.length) === 0,
        display: "empty",
        iconType: "boxesHorizontal",
        size: "s",
        onClick: handleClickActions,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 103,
          columnNumber: 23
        }
      }),
      panelPaddingSize: "s",
      closePopover: handleClickActions,
      isOpen: isActionsPopoverOpen,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 100,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
      size: "s",
      items: actions === null || actions === void 0 ? void 0 : actions.map(({
        id,
        icon,
        label,
        handler
      }) => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
        key: id,
        icon: icon,
        onClick: handler,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 127,
          columnNumber: 25
        }
      }, label)),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 21
      }
    }))) : null) : null,
    onToggle: onToggle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    color: "subdued",
    "data-test-subj": "obsAiAssistantInsightResponse",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 9
    }
  }, children)));
}