"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricCell = MetricCell;
exports.OfflineCell = OfflineCell;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _format_number = require("../../../lib/format_number");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/elasticsearch/nodes/cells.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const offlineStyle = ({
  euiTheme
}) => (0, _react2.css)`
  color: ${euiTheme.colors.textParagraph};
`;
const TRENDING_DOWN = _i18n.i18n.translate('xpack.monitoring.elasticsearch.node.cells.trendingDownText', {
  defaultMessage: 'down'
});
const TRENDING_UP = _i18n.i18n.translate('xpack.monitoring.elasticsearch.node.cells.trendingUpText', {
  defaultMessage: 'up'
});
function OfflineCell() {
  return /*#__PURE__*/_react.default.createElement("div", {
    css: offlineStyle,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 10
    }
  }, "N/A");
}
const getDirection = slope => {
  if (slope || slope === 0) {
    return slope > 0 ? TRENDING_UP : TRENDING_DOWN;
  }
  return null;
};
const getIcon = slope => {
  if (slope || slope === 0) {
    return slope > 0 ? 'sortUp' : 'sortDown';
  }
  return null;
};
const metricVal = (metric, format, isPercent, units) => {
  if (isPercent) {
    return (0, _format_number.formatMetric)(metric, format, '%', {
      prependSpace: false
    });
  }
  return (0, _format_number.formatMetric)(metric, format, units);
};
function MetricCell({
  isOnline,
  metric = {},
  isPercent,
  ...props
}) {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onButtonClick = () => setIsPopoverOpen(isPopoverOpen => !isPopoverOpen);
  const closePopover = () => setIsPopoverOpen(false);
  if (!isOnline) {
    return /*#__PURE__*/_react.default.createElement(OfflineCell, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 12
      }
    });
  }
  const {
    lastVal,
    maxVal,
    minVal,
    slope
  } = (0, _lodash.get)(metric, 'summary', {});
  const format = (0, _lodash.get)(metric, 'metric.format');
  const units = (0, _lodash.get)(metric, 'metric.units');
  const tooltipItems = [{
    title: _i18n.i18n.translate('xpack.monitoring.elasticsearch.node.cells.tooltip.trending', {
      defaultMessage: 'Trending'
    }),
    description: getDirection(slope)
  }, {
    title: _i18n.i18n.translate('xpack.monitoring.elasticsearch.node.cells.tooltip.max', {
      defaultMessage: 'Max value'
    }),
    description: metricVal(maxVal, format, isPercent, units)
  }, {
    title: _i18n.i18n.translate('xpack.monitoring.elasticsearch.node.cells.tooltip.min', {
      defaultMessage: 'Min value'
    }),
    description: metricVal(minVal, format, isPercent, units)
  }];
  const iconLabel = _i18n.i18n.translate('xpack.monitoring.elasticsearch.node.cells.tooltip.iconLabel', {
    defaultMessage: 'More information about this metric'
  });
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "text",
    onClick: onButtonClick,
    iconType: getIcon(slope),
    "data-test-subj": `monitoringCellIcon-${props['data-test-subj']}`,
    title: iconLabel,
    "aria-label": iconLabel,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": props['data-test-subj'],
    gutterSize: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": `monitoringCellPopover-${props['data-test-subj']}`,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    type: "column",
    compressed: true,
    listItems: tooltipItems,
    style: {
      maxWidth: '150px'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.monitoring.elasticsearch.node.cells.tooltip.preface', {
    defaultMessage: 'Applies to current time period'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 13
    }
  }, metricVal(lastVal, format, isPercent))))));
}