"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyDetectionOverviewCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _locator = require("../../../locator");
var _anomaly_detection_kibana = _interopRequireDefault(require("../../jobs/jobs_list/components/anomaly_detection_empty_state/anomaly_detection_kibana.png"));
var _check_capabilities = require("../../capabilities/check_capabilities");
var _ml_nodes_check = require("../../ml_nodes_check");
var _kibana = require("../../contexts/kibana");
var _anomaly_detection_empty_state = require("../../jobs/jobs_list/components/anomaly_detection_empty_state/anomaly_detection_empty_state");
var _ml_empty_prompt_card = require("../../components/overview/ml_empty_prompt_card");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/overview/components/anomaly_detection_overview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnomalyDetectionOverviewCard = () => {
  const [canGetJobs, canCreateJob] = (0, _check_capabilities.usePermissionCheck)(['canGetJobs', 'canCreateJob']);
  const disableCreateAnomalyDetectionJob = !canCreateJob || !(0, _ml_nodes_check.mlNodesAvailable)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [hasADJobs, setHasADJobs] = (0, _react.useState)(false);
  const mlApi = (0, _kibana.useMlApi)();
  const mlLocator = (0, _kibana.useMlLocator)();
  const mlManagementLocator = (0, _kibana.useMlManagementLocator)();
  const loadJobs = (0, _react.useCallback)(async () => {
    setIsLoading(true);
    try {
      const jobsResult = await mlApi.jobs.jobsSummary([]);
      if ((jobsResult === null || jobsResult === void 0 ? void 0 : jobsResult.length) > 0) {
        setHasADJobs(true);
      }
      setIsLoading(false);
    } catch (e) {
      setIsLoading(false);
    }
  }, [mlApi]);
  (0, _react.useEffect)(() => {
    loadJobs();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const redirectToMultiMetricExplorer = (0, _react.useCallback)(async () => {
    if (!mlLocator) return;
    await mlLocator.navigate({
      sectionId: 'ml',
      page: _locator.ML_PAGES.ANOMALY_EXPLORER
    });
  }, [mlLocator]);
  const redirectToManageJobs = (0, _react.useCallback)(async () => {
    if (!mlManagementLocator) return;
    await mlManagementLocator.navigate({
      sectionId: 'ml',
      appId: `anomaly_detection`
    });
  }, [mlManagementLocator]);
  const showEmptyState = !isLoading && !hasADJobs;
  const availableActions = (0, _react.useMemo)(() => {
    const actions = [];
    if (hasADJobs) {
      actions.push(/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "primary",
        fill: true,
        onClick: redirectToMultiMetricExplorer,
        isDisabled: !canGetJobs,
        "data-test-subj": "multiMetricExplorerButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.overview.anomalyDetection.anomalyExplorerButtonText",
        defaultMessage: "Anomaly explorer",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 11
        }
      })));
    }
    if (canGetJobs && canCreateJob) {
      actions.push(/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "primary",
        onClick: redirectToManageJobs,
        isDisabled: disableCreateAnomalyDetectionJob,
        "data-test-subj": "manageJobsButton",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 91,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.overview.anomalyDetection.manageJobsButton",
        defaultMessage: "Manage jobs",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 11
        }
      })));
    }
    return actions;
  }, [disableCreateAnomalyDetectionJob, hasADJobs, canCreateJob, canGetJobs, redirectToMultiMetricExplorer, redirectToManageJobs]);
  return showEmptyState ? /*#__PURE__*/_react.default.createElement(_anomaly_detection_empty_state.AnomalyDetectionEmptyState, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 5
    }
  }) : /*#__PURE__*/_react.default.createElement(_ml_empty_prompt_card.MLEmptyPromptCard, {
    layout: "horizontal",
    hasBorder: true,
    hasShadow: false,
    iconSrc: _anomaly_detection_kibana.default,
    iconAlt: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.title', {
      defaultMessage: 'Anomaly detection'
    }),
    title: _i18n.i18n.translate('xpack.ml.overview.anomalyDetection.createFirstJobMessage', {
      defaultMessage: 'Spot anomalies faster'
    }),
    body: /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.anomalyDetection.emptyPromptText",
      defaultMessage: "Start automatically spotting anomalies hiding in your time series data and resolve issues faster.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 11
      }
    })),
    actions: availableActions,
    "data-test-subj": "mlOverviewAnomalyDetectionCard",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 5
    }
  });
};
exports.AnomalyDetectionOverviewCard = AnomalyDetectionOverviewCard;