"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RareInPopulationCard = exports.RareCard = exports.FrequentlyRareInPopulationCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/jobs/new_job/pages/components/pick_fields_step/components/rare_detector/detector_cards.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const RareCard = ({
  onClick,
  isSelected
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 20,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
  "data-test-subj": `mlJobWizardCategorizationDetectorRareCard${isSelected ? ' selected' : ''}`,
  title: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.rareDetectorSelect.rareCard.title', {
    defaultMessage: 'Rare'
  }),
  description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.rareDetectorSelect.rareCard.description",
    defaultMessage: "Find rare values over time.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 11
    }
  })),
  selectable: {
    onClick,
    isSelected
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 21,
    columnNumber: 5
  }
}));
exports.RareCard = RareCard;
const RareInPopulationCard = ({
  onClick,
  isSelected
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 43,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
  "data-test-subj": `mlJobWizardCategorizationDetectorRareCard${isSelected ? ' selected' : ''}`,
  title: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.rareDetectorSelect.rarePopulationCard.title', {
    defaultMessage: 'Rare in population'
  }),
  description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.rareDetectorSelect.rarePopulationCard.description",
    defaultMessage: "Find members of a population that have rare values over time.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 11
    }
  })),
  selectable: {
    onClick,
    isSelected
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 44,
    columnNumber: 5
  }
}));
exports.RareInPopulationCard = RareInPopulationCard;
const FrequentlyRareInPopulationCard = ({
  onClick,
  isSelected
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 66,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
  "data-test-subj": `mlJobWizardCategorizationDetectorRareCard${isSelected ? ' selected' : ''}`,
  title: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.rareDetectorSelect.freqRareCard.title', {
    defaultMessage: 'Frequently rare in population'
  }),
  description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.rareDetectorSelect.freqRareCard.description",
    defaultMessage: "Find members of a population that frequently have rare values.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 11
    }
  })),
  selectable: {
    onClick,
    isSelected
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 67,
    columnNumber: 5
  }
}));
exports.FrequentlyRareInPopulationCard = FrequentlyRareInPopulationCard;