"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsIdSelector = AnalyticsIdSelector;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _mlTrainedModelsUtils = require("@kbn/ml-trained-models-utils");
var _trained_models = require("../../../../services/ml_api_service/trained_models");
var _toast_notification_service = require("../../../../services/toast_notification_service");
var _config_mapping = require("../../../../model_management/config_mapping");
var _kibana = require("../../../../contexts/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/components/analytics_selector/analytics_id_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function isDataFrameAnalyticsConfigs(arg) {
  return arg.dest && arg.analysis && arg.id;
}
const columns = [{
  field: 'id',
  name: _i18n.i18n.translate('xpack.ml.analyticsSelector.id', {
    defaultMessage: 'ID'
  }),
  sortable: item => item.id,
  truncateText: true,
  'data-test-subj': 'mlAnalyticsSelectorTableColumnId',
  scope: 'row'
}, {
  field: 'description',
  name: _i18n.i18n.translate('xpack.ml.analyticsSelector.description', {
    defaultMessage: 'Description'
  }),
  sortable: true,
  truncateText: true,
  'data-test-subj': 'mlAnalyticsSelectorColumnJobDescription'
}, {
  field: 'source.index',
  name: _i18n.i18n.translate('xpack.ml.analyticsSelector.sourceIndex', {
    defaultMessage: 'Source index'
  }),
  sortable: true,
  truncateText: true,
  'data-test-subj': 'mlAnalyticsSelectorColumnSourceIndex'
}, {
  field: 'dest.index',
  name: _i18n.i18n.translate('xpack.ml.analyticsSelector.destinationIndex', {
    defaultMessage: 'Destination index'
  }),
  sortable: true,
  truncateText: true,
  'data-test-subj': 'mlAnalyticsSelectorColumnDestIndex'
}];
const modelColumns = [{
  field: _config_mapping.ModelsTableToConfigMapping.id,
  name: _i18n.i18n.translate('xpack.ml.analyticsSelector.modelsList.modelIdHeader', {
    defaultMessage: 'ID'
  }),
  sortable: true,
  truncateText: false,
  'data-test-subj': 'mlAnalyticsSelectorColumnId'
}, {
  field: _config_mapping.ModelsTableToConfigMapping.description,
  width: '350px',
  name: _i18n.i18n.translate('xpack.ml.analyticsSelector.modelsList.modelDescriptionHeader', {
    defaultMessage: 'Description'
  }),
  sortable: false,
  truncateText: false,
  'data-test-subj': 'mlAnalyticsSelectorColumnDescription'
}];
function AnalyticsIdSelector({
  setAnalyticsId,
  jobsOnly = false,
  setIsIdSelectorFlyoutVisible
}) {
  const [selected, setSelected] = (0, _react.useState)();
  const flyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'jobSelectorFlyout'
  });
  const [analyticsJobs, setAnalyticsJobs] = (0, _react.useState)([]);
  const [trainedModels, setTrainedModels] = (0, _react.useState)([]);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const {
    displayErrorToast
  } = (0, _toast_notification_service.useToastNotificationService)();
  const trainedModelsApiService = (0, _trained_models.useTrainedModelsApiService)();
  const {
    dataFrameAnalytics: {
      getDataFrameAnalytics
    }
  } = (0, _kibana.useMlApi)();
  function renderTabs() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
      size: "s",
      tabs: tabs,
      initialSelectedTab: tabs[0],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 137,
        columnNumber: 12
      }
    });
  }
  async function fetchAnalyticsJobs() {
    setIsLoading(true);
    try {
      const {
        data_frame_analytics: dataFrameAnalytics
      } = await getDataFrameAnalytics();
      setAnalyticsJobs(dataFrameAnalytics);
    } catch (e) {
      console.error('Error fetching analytics', e); // eslint-disable-line no-console
      displayErrorToast(e, _i18n.i18n.translate('xpack.ml.analyticsSelector.analyticsFetchErrorMessage', {
        defaultMessage: 'An error occurred fetching analytics jobs. Refresh and try again.'
      }));
    }
    setIsLoading(false);
  }
  async function fetchAnalyticsModels() {
    setIsLoading(true);
    try {
      // FIXME should if fetch all trained models?
      const response = await trainedModelsApiService.getTrainedModels();
      setTrainedModels(response);
    } catch (e) {
      console.error('Error fetching trained models', e); // eslint-disable-line no-console
      displayErrorToast(e, _i18n.i18n.translate('xpack.ml.analyticsSelector.trainedModelsFetchErrorMessage', {
        defaultMessage: 'An error occurred fetching trained models. Refresh and try again.'
      }));
    }
    setIsLoading(false);
  }
  function closeFlyout() {
    setIsIdSelectorFlyoutVisible(false);
  }

  // Fetch analytics jobs and models on flyout open
  (0, _react.useEffect)(() => {
    fetchAnalyticsJobs();
    if (jobsOnly === false) {
      fetchAnalyticsModels();
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const applySelection = (0, _react.useCallback)(() => {
    if (selected !== undefined) {
      setAnalyticsId(selected);
    }
    closeFlyout();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selected === null || selected === void 0 ? void 0 : selected.model_id, selected === null || selected === void 0 ? void 0 : selected.job_id]);
  const pagination = {
    initialPageSize: 20,
    pageSizeOptions: [5, 10, 20, 50]
  };
  const selectionValue = {
    selectable: item => {
      const isDFA = isDataFrameAnalyticsConfigs(item);
      const itemId = isDFA ? item.id : item.model_id;
      const isBuiltInModel = isDFA ? false : item.tags.includes(_mlTrainedModelsUtils.BUILT_IN_MODEL_TAG);
      return (selected === undefined || (selected === null || selected === void 0 ? void 0 : selected.job_id) === itemId || (selected === null || selected === void 0 ? void 0 : selected.model_id) === itemId) && !isBuiltInModel;
    },
    onSelectionChange: selectedItem => {
      var _item$metadata, _item$metadata$analyt;
      const item = selectedItem[0];
      if (!item) {
        setSelected(undefined);
        return;
      }
      const isDFA = isDataFrameAnalyticsConfigs(item);
      const config = isDFA ? item.analysis : item.inference_config;
      const analysisType = config ? Object.keys(config)[0] : undefined;
      setSelected({
        model_id: isDFA ? undefined : item.model_id,
        job_id: isDFA ? item.id : (_item$metadata = item.metadata) === null || _item$metadata === void 0 ? void 0 : (_item$metadata$analyt = _item$metadata.analytics_config) === null || _item$metadata$analyt === void 0 ? void 0 : _item$metadata$analyt.id,
        analysis_type: analysisType
      });
    }
  };
  const tabs = [{
    id: 'Jobs',
    name: _i18n.i18n.translate('xpack.ml.analyticsSelector.jobsTab', {
      defaultMessage: 'Jobs'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      items: analyticsJobs,
      itemId: "id",
      loading: isLoading,
      columns: columns,
      pagination: pagination,
      sorting: true,
      selection: selectionValue,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 238,
        columnNumber: 9
      }
    })
  }];
  if (jobsOnly === false) {
    tabs.push({
      id: 'Models',
      name: _i18n.i18n.translate('xpack.ml.analyticsSelector.modelsTab', {
        defaultMessage: 'Models'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
        items: trainedModels,
        itemId: "model_id",
        loading: isLoading,
        columns: modelColumns,
        pagination: pagination,
        sorting: true,
        selection: selectionValue,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 258,
          columnNumber: 9
        }
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: closeFlyout,
    "data-test-subj": "mlFlyoutJobSelector",
    "aria-labelledby": flyoutTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 272,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 11
    }
  }, _i18n.i18n.translate('xpack.ml.analyticsSelector.flyoutTitle', {
    defaultMessage: 'Analytics selection'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": 'mlJobSelectorFlyoutBody',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 286,
      columnNumber: 7
    }
  }, renderTabs()), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 287,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    onClick: closeFlyout,
    "data-test-subj": "mlFlyoutAnalyticsSelectorButtonClose",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 290,
      columnNumber: 13
    }
  }, _i18n.i18n.translate('xpack.ml.analyticsSelector.closeFlyoutButton', {
    defaultMessage: 'Close'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 300,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: applySelection,
    fill: true,
    isDisabled: selected === undefined,
    "data-test-subj": "mlFlyoutAnalyticsSelectorButtonApply",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 301,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.analyticsSelector.applyFlyoutButton",
    defaultMessage: "Apply",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 307,
      columnNumber: 15
    }
  }))))));
}