"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsDetailFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlUrlState = require("@kbn/ml-url-state");
var _use_create_url = require("../../../../../contexts/kibana/use_create_url");
var _job_details_flyout = require("../../../../../jobs/components/job_details_flyout");
var _analytics_service = require("../../../analytics_management/services/analytics_service");
var _locator = require("../../../../../../locator");
var _expanded_row = require("../../../analytics_management/components/analytics_list/expanded_row");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_exploration/components/analytics_detail_flyout/analytics_detail_flyout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AnalyticsDetailFlyout = () => {
  var _globalState$ml2;
  const {
    isDataFrameAnalyticsDetailsFlyoutOpen,
    closeActiveFlyout,
    setActiveJobId,
    activeJobId: analyticsId
  } = (0, _job_details_flyout.useJobInfoFlyouts)();
  const [analytics, setAnalytics] = (0, _react.useState)([]);
  const [, setAnalyticsStats] = (0, _react.useState)(undefined);
  const [, setErrorMessage] = (0, _react.useState)(undefined);
  const [, setIsInitialized] = (0, _react.useState)(false);
  const [, setJobsAwaitingNodeCount] = (0, _react.useState)(0);
  const blockRefresh = false;
  const getAnalytics = (0, _analytics_service.useGetAnalytics)(setAnalytics, setAnalyticsStats, setErrorMessage, setIsInitialized, setJobsAwaitingNodeCount, blockRefresh);
  const getAnalyticsCallback = (0, _react.useCallback)(id => getAnalytics(true, id), [getAnalytics]);

  // Subscribe to the refresh observable to trigger reloading the analytics list.

  (0, _react.useEffect)(function getAnalyticsDetailsOnChange() {
    if (!analyticsId) {
      return;
    }
    getAnalyticsCallback(analyticsId);
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [analyticsId]);
  const analytic = (0, _react.useMemo)(() => analytics.find(a => a.id === analyticsId), [analytics, analyticsId]);
  const [globalState] = (0, _mlUrlState.useUrlState)('_g');
  const pageState = (0, _react.useMemo)(() => {
    var _globalState$ml;
    return {
      jobId: globalState === null || globalState === void 0 ? void 0 : (_globalState$ml = globalState.ml) === null || _globalState$ml === void 0 ? void 0 : _globalState$ml.jobId
    };
  }, [globalState === null || globalState === void 0 ? void 0 : (_globalState$ml2 = globalState.ml) === null || _globalState$ml2 === void 0 ? void 0 : _globalState$ml2.jobId]);
  const redirectToAnalyticsList = (0, _use_create_url.useCreateAndNavigateToManagementMlLink)(_locator.ML_PAGES.DATA_FRAME_ANALYTICS_JOBS_MANAGE, 'analytics', pageState);
  const flyoutTitleId = `mlAnalyticsDetailsFlyout-${analyticsId}`;
  return isDataFrameAnalyticsDetailsFlyoutOpen ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "data-test-subj": "analyticsDetailsFlyout",
    type: "overlay",
    size: "m",
    ownFocus: false,
    onClose: () => {
      closeActiveFlyout();
      setActiveJobId(null);
    },
    "aria-labelledby": flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true,
    "data-test-subj": `analyticsDetailsFlyout-${analyticsId}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: flyoutTitleId,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 15
    }
  }, analyticsId))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: redirectToAnalyticsList,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.jobDetailsFlyout.manageJobButton",
    defaultMessage: "Manage job",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 15
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 7
    }
  }, analytic ? /*#__PURE__*/_react.default.createElement(_expanded_row.ExpandedRow, {
    item: analytic,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  })))) : null;
};
exports.AnalyticsDetailFlyout = AnalyticsDetailFlyout;