"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OutlierHyperParameters = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDataFrameAnalyticsUtils = require("@kbn/ml-data-frame-analytics-utils");
var _advanced_step_form = require("./advanced_step_form");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/data_frame_analytics/pages/analytics_creation/components/advanced_step/outlier_hyper_parameters.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OutlierHyperParameters = ({
  actions,
  state,
  advancedParamErrors
}) => {
  const {
    setFormState
  } = actions;
  const {
    method,
    nNeighbors,
    outlierFraction,
    standardizationEnabled
  } = state.form;
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.methodLabel', {
      defaultMessage: 'Method'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.methodHelpText', {
      defaultMessage: 'Set the method that outlier detection uses. If not set, uses an ensemble of different methods, normalizes and combines their individual outlier scores to obtain the overall outlier score. It is recommended to use the ensemble method.'
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.METHOD] !== undefined,
    error: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.METHOD],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.METHOD] !== undefined,
    options: Object.values(_mlDataFrameAnalyticsUtils.OUTLIER_ANALYSIS_METHOD).map(outlierMethod => ({
      value: outlierMethod,
      text: outlierMethod
    })),
    value: method,
    hasNoInitialSelection: true,
    onChange: e => {
      setFormState({
        method: e.target.value
      });
    },
    "data-test-subj": "mlAnalyticsCreateJobWizardMethodInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 43,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.nNeighborsLabel', {
      defaultMessage: 'N neighbors'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.nNeighborsHelpText', {
      defaultMessage: 'The value for how many nearest neighbors each method of outlier detection uses to calculate its outlier score. When not set, different values are used for different ensemble members. Must be a positive integer.'
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.N_NEIGHBORS] !== undefined,
    error: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.N_NEIGHBORS],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.N_NEIGHBORS] !== undefined,
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.nNeighborsInputAriaLabel', {
      defaultMessage: 'The value for how many nearest neighbors each method of outlier detection uses to calculate its outlier score.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardnNeighborsInput",
    onChange: e => setFormState({
      nNeighbors: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 1,
    min: 1,
    value: (0, _advanced_step_form.getNumberValue)(nNeighbors),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.outlierFractionLabel', {
      defaultMessage: 'Outlier fraction'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.outlierFractionHelpText', {
      defaultMessage: 'Set the proportion of the data set that is assumed to be outlying prior to outlier detection.'
    }),
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.OUTLIER_FRACTION] !== undefined,
    error: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.OUTLIER_FRACTION],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    isInvalid: advancedParamErrors[_mlDataFrameAnalyticsUtils.ANALYSIS_ADVANCED_FIELDS.OUTLIER_FRACTION] !== undefined,
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.outlierFractionInputAriaLabel', {
      defaultMessage: 'Sets the proportion of the data set that is assumed to be outlying prior to outlier detection.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardoutlierFractionInput",
    onChange: e => setFormState({
      outlierFraction: e.target.value === '' ? undefined : +e.target.value
    }),
    step: 0.001,
    min: 0,
    max: 1,
    value: (0, _advanced_step_form.getNumberValue)(outlierFraction),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 11
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.standardizationEnabledLabel', {
      defaultMessage: 'Standardization enabled'
    }),
    helpText: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.standardizationEnabledHelpText', {
      defaultMessage: 'If true, the following operation is performed on the columns before computing outlier scores: (x_i - mean(x_i)) / sd(x_i).'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.standardizationEnabledInputAriaLabel', {
      defaultMessage: 'Sets standardization enabled setting.'
    }),
    "data-test-subj": "mlAnalyticsCreateJobWizardStandardizationEnabledInput",
    options: [{
      value: 'true',
      text: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.standardizationEnabledTrueValue', {
        defaultMessage: 'True'
      })
    }, {
      value: 'false',
      text: _i18n.i18n.translate('xpack.ml.dataframe.analytics.create.standardizationEnabledFalseValue', {
        defaultMessage: 'False'
      })
    }],
    value: standardizationEnabled ? 'true' : 'false',
    hasNoInitialSelection: true,
    onChange: e => {
      setFormState({
        standardizationEnabled: e.target.value === 'true' ? true : false
      });
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  }))));
};
exports.OutlierHyperParameters = OutlierHyperParameters;