"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateCalendar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _event_rate_chart = require("../../../jobs/new_job/pages/components/charts/event_rate_chart/event_rate_chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/model_snapshots/revert_model_snapshot_flyout/create_calendar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateCalendar = ({
  calendarEvents,
  setCalendarEvents,
  minSelectableTimeStamp,
  maxSelectableTimeStamp,
  eventRateData,
  anomalies,
  chartReady
}) => {
  const maxSelectableTimeMoment = (0, _moment.default)(maxSelectableTimeStamp);
  const minSelectableTimeMoment = (0, _moment.default)(minSelectableTimeStamp);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const onBrushEnd = (0, _react.useCallback)(({
    x
  }) => {
    if (x && x.length === 2) {
      const end = x[1] < minSelectableTimeStamp ? null : x[1];
      if (end !== null) {
        const start = x[0] < minSelectableTimeStamp ? minSelectableTimeStamp : x[0];
        setCalendarEvents([...calendarEvents, {
          start: (0, _moment.default)(start),
          end: (0, _moment.default)(end),
          description: createDefaultEventDescription(calendarEvents.length + 1)
        }]);
      }
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [calendarEvents]);
  const setStartDate = (0, _react.useCallback)((start, index) => {
    const event = calendarEvents[index];
    if (event === undefined) {
      setCalendarEvents([...calendarEvents, {
        start,
        end: null,
        description: createDefaultEventDescription(index)
      }]);
    } else {
      event.start = start;
      setCalendarEvents([...calendarEvents]);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [calendarEvents]);
  const setEndDate = (0, _react.useCallback)((end, index) => {
    const event = calendarEvents[index];
    if (event === undefined) {
      setCalendarEvents([...calendarEvents, {
        start: null,
        end,
        description: createDefaultEventDescription(index)
      }]);
    } else {
      event.end = end;
      setCalendarEvents([...calendarEvents]);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [calendarEvents]);
  const setDescription = (0, _react.useCallback)((description, index) => {
    const event = calendarEvents[index];
    if (event !== undefined) {
      event.description = description;
      setCalendarEvents([...calendarEvents]);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [calendarEvents]);
  const removeCalendarEvent = (0, _react.useCallback)(index => {
    if (calendarEvents[index] !== undefined) {
      const ce = [...calendarEvents];
      ce.splice(index, 1);
      setCalendarEvents(ce);
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [calendarEvents]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 141,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.revertModelSnapshotFlyout.createCalendar.title",
    defaultMessage: "Select time range for calendar event.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 148,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(Chart, {
    eventRateData: eventRateData,
    anomalies: anomalies,
    loading: chartReady === false,
    overlayRanges: calendarEvents.filter(filterIncompleteEvents).map(c => ({
      start: c.start.valueOf(),
      end: c.end.valueOf()
    })),
    onBrushEnd: onBrushEnd,
    overlayColor: euiTheme.colors.primary,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 7
    }
  }), calendarEvents.map((c, i) => {
    var _c$end, _c$start;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: i,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 163,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      paddingSize: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 164,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 165,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 166,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 167,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 168,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.ml.revertModelSnapshotFlyout.createCalendar.fromLabel', {
        defaultMessage: 'From'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 169,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      showTimeSelect: true,
      selected: c.start,
      minDate: minSelectableTimeMoment,
      maxDate: (_c$end = c.end) !== null && _c$end !== void 0 ? _c$end : maxSelectableTimeMoment,
      onChange: d => setStartDate(d, i),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 23
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.ml.revertModelSnapshotFlyout.createCalendar.toLabel', {
        defaultMessage: 'To'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      showTimeSelect: true,
      selected: c.end,
      minDate: (_c$start = c.start) !== null && _c$start !== void 0 ? _c$start : minSelectableTimeMoment,
      maxDate: maxSelectableTimeMoment,
      onChange: d => setEndDate(d, i),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 23
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 17
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 207,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: _i18n.i18n.translate('xpack.ml.revertModelSnapshotFlyout.createCalendar.descriptionLabel', {
        defaultMessage: 'Description'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      value: c.description,
      onChange: e => setDescription(e.target.value, i),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 217,
        columnNumber: 23
      }
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      style: {
        borderLeft: `1px solid ${euiTheme.colors.lightShade}`,
        marginRight: '0px'
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 226,
        columnNumber: 15
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 233,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      style: {
        margin: 'auto'
      },
      color: 'danger',
      onClick: () => removeCalendarEvent(i),
      iconType: "trash",
      "aria-label": _i18n.i18n.translate('xpack.ml.revertModelSnapshotFlyout.createCalendar.deleteLabel', {
        defaultMessage: 'Delete event'
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 234,
        columnNumber: 17
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 249,
        columnNumber: 11
      }
    }));
  }));
};
exports.CreateCalendar = CreateCalendar;
const Chart = /*#__PURE__*/(0, _react.memo)(({
  eventRateData,
  anomalies,
  loading,
  onBrushEnd,
  overlayRanges,
  overlayColor
}) => /*#__PURE__*/_react.default.createElement(_event_rate_chart.EventRateChart, {
  eventRateChartData: eventRateData,
  anomalyData: anomalies,
  loading: loading,
  height: '100px',
  width: '100%',
  fadeChart: true,
  overlayRanges: overlayRanges.map(c => ({
    start: c.start,
    end: c.end,
    color: overlayColor,
    showMarker: false
  })),
  onBrushEnd: onBrushEnd,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 267,
    columnNumber: 5
  }
}), (prev, next) => {
  // only redraw if the calendar ranges have changes
  return prev.overlayRanges.length === next.overlayRanges.length && JSON.stringify(prev.overlayRanges) === JSON.stringify(next.overlayRanges);
});
function filterIncompleteEvents(event) {
  return event.start !== null && event.end !== null;
}
function createDefaultEventDescription(index) {
  return _i18n.i18n.translate('xpack.ml.revertModelSnapshotFlyout.createCalendar.defaultEventDescription', {
    defaultMessage: 'Auto created event {index}',
    values: {
      index
    }
  });
}