"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateDataViewTimeField = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/packages/private/ml/data_view_utils/components/create_data_view_time_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const CreateDataViewTimeField = ({
  dataViewAvailableTimeFields,
  dataViewTimeField,
  onTimeFieldChanged
}) => {
  const noTimeFieldLabel = _i18n.i18n.translate('xpack.ml.dataViewUtils.noTimeFieldOptionLabel', {
    defaultMessage: "I don't want to use the time field option"
  });
  const noTimeFieldOption = {
    text: noTimeFieldLabel,
    value: undefined
  };
  const disabledDividerOption = {
    disabled: true,
    text: '───',
    value: ''
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataViewUtils.dataViewTimeFieldLabel",
      defaultMessage: "Time field for data view",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 9
      }
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.dataViewUtils.dataViewTimeFieldHelpText",
      defaultMessage: "Select a primary time field for use with the global time filter.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 49,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 41,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: [...dataViewAvailableTimeFields.map(text => ({
      text
    })), disabledDividerOption, noTimeFieldOption],
    value: dataViewTimeField,
    onChange: onTimeFieldChanged,
    "data-test-subj": "mlDataViewTimeFieldSelect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }));
};
exports.CreateDataViewTimeField = CreateDataViewTimeField;