"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.nodeCpuUsed = exports.nodeCpuCapacity = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const nodeCpuCapacity = exports.nodeCpuCapacity = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.kubernetes.capacity', {
    defaultMessage: 'Capacity'
  }),
  value: 'max(kubernetes.node.cpu.allocatable.cores) * 1000000000',
  format: 'number',
  decimals: 1,
  compactValues: true
};
const nodeCpuUsed = exports.nodeCpuUsed = {
  label: _i18n.i18n.translate('xpack.metricsData.assetDetails.formulas.kubernetes.used', {
    defaultMessage: 'Used'
  }),
  value: 'average(kubernetes.node.cpu.usage.nanocores)',
  format: 'number',
  decimals: 1,
  compactValues: true
};