"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomIconsPanel = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../common/constants");
var _kibana_services = require("../../kibana_services");
var _symbol_icon = require("../../classes/styles/vector/components/legend/symbol_icon");
var _custom_icon_modal = require("../../classes/styles/vector/components/symbol/custom_icon_modal");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/map_settings_panel/custom_icons_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class CustomIconsPanel extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      isModalVisible: false,
      selectedIcon: undefined
    });
    (0, _defineProperty2.default)(this, "_handleIconEdit", icon => {
      this.setState({
        selectedIcon: icon,
        isModalVisible: true
      });
    });
    (0, _defineProperty2.default)(this, "_handleNewIcon", () => {
      this.setState({
        isModalVisible: true
      });
    });
    (0, _defineProperty2.default)(this, "_renderModal", () => {
      if (!this.state.isModalVisible) {
        return null;
      }
      if (this.state.selectedIcon) {
        const {
          symbolId,
          label,
          svg,
          cutoff,
          radius
        } = this.state.selectedIcon;
        return /*#__PURE__*/_react.default.createElement(_custom_icon_modal.CustomIconModal, {
          title: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.editCustomIcon', {
            defaultMessage: 'Edit custom icon'
          }),
          symbolId: symbolId,
          label: label,
          svg: svg,
          cutoff: cutoff || _constants.DEFAULT_CUSTOM_ICON_CUTOFF,
          radius: radius || _constants.DEFAULT_CUSTOM_ICON_RADIUS,
          onSave: this._handleSave,
          onCancel: this._hideModal,
          onDelete: this._handleDelete,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 59,
            columnNumber: 9
          }
        });
      }
      return /*#__PURE__*/_react.default.createElement(_custom_icon_modal.CustomIconModal, {
        title: _i18n.i18n.translate('xpack.maps.mapSettingsPanel.addCustomIcon', {
          defaultMessage: 'Add custom icon'
        }),
        cutoff: _constants.DEFAULT_CUSTOM_ICON_CUTOFF,
        radius: _constants.DEFAULT_CUSTOM_ICON_RADIUS,
        onSave: this._handleSave,
        onCancel: this._hideModal,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 7
        }
      });
    });
    (0, _defineProperty2.default)(this, "_hideModal", () => {
      this.setState({
        isModalVisible: false,
        selectedIcon: undefined
      });
    });
    (0, _defineProperty2.default)(this, "_handleSave", icon => {
      const {
        symbolId,
        label,
        svg,
        cutoff,
        radius
      } = icon;
      const icons = [...this.props.customIcons.filter(i => {
        return i.symbolId !== symbolId;
      }), {
        symbolId,
        svg,
        label,
        cutoff,
        radius
      }];
      this.props.updateCustomIcons(icons);
      this._hideModal();
    });
    (0, _defineProperty2.default)(this, "_handleDelete", symbolId => {
      this.props.deleteCustomIcon(symbolId);
      this._hideModal();
    });
    (0, _defineProperty2.default)(this, "_renderCustomIconsList", () => {
      const addIconButton = /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 117,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
        textAlign: "center",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        iconType: "plusInCircleFilled",
        onClick: () => this._handleNewIcon(),
        "data-test-subj": "mapsCustomIconPanel-add",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 119,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.maps.mapSettingsPanel.customIconsAddIconButton",
        defaultMessage: "Add",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 125,
          columnNumber: 13
        }
      }))));
      if (!this.props.customIcons.length) {
        return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 135,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "s",
          textAlign: "center",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 136,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 137,
            columnNumber: 13
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: "subdued",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 138,
            columnNumber: 15
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.maps.mapSettingsPanel.customIcons.emptyState.description",
          defaultMessage: "Add a custom icon that can be used in layers in this map.",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 139,
            columnNumber: 17
          }
        })))), addIconButton);
      }
      const customIconsList = this.props.customIcons.map(icon => {
        const {
          symbolId,
          label,
          svg
        } = icon;
        return {
          label,
          key: symbolId,
          icon: /*#__PURE__*/_react.default.createElement(_symbol_icon.SymbolIcon, {
            symbolId: label,
            svg: svg,
            fill: (0, _kibana_services.getIsDarkMode)() ? 'rgb(223, 229, 239)' : 'rgb(52, 55, 65)',
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 157,
              columnNumber: 11
            }
          }),
          extraAction: {
            iconType: 'gear',
            alwaysShow: true,
            onClick: () => {
              this._handleIconEdit(icon);
            }
          }
        };
      });
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 174,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
        listItems: customIconsList,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 175,
          columnNumber: 9
        }
      }), addIconButton);
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 185,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("h5", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 186,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.maps.mapSettingsPanel.customIconsTitle",
      defaultMessage: "Custom icons",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 193,
        columnNumber: 11
      }
    }), this._renderCustomIconsList()), this._renderModal());
  }
}
exports.CustomIconsPanel = CustomIconsPanel;