"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Join = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/data-plugin/public");
var _spatial_join_expression = require("./spatial_join_expression");
var _term_join_expression = require("./term_join_expression");
var _metrics_expression = require("./metrics_expression");
var _where_expression = require("./where_expression");
var _global_filter_checkbox = require("../../../../components/global_filter_checkbox");
var _global_time_checkbox = require("../../../../components/global_time_checkbox");
var _kibana_services = require("../../../../kibana_services");
var _i18n_getters = require("../../../../../common/i18n_getters");
var _constants = require("../../../../../common/constants");
var _is_spatial_join = require("../../../../classes/joins/is_spatial_join");
var _join_sources = require("../../../../classes/sources/join_sources");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/edit_layer_panel/join_editor/resources/join.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class Join extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "_nextIndexPatternId", void 0);
    (0, _defineProperty2.default)(this, "state", {
      rightFields: [],
      indexPattern: undefined,
      loadError: undefined
    });
    (0, _defineProperty2.default)(this, "_onLeftFieldChange", leftField => {
      this.props.onChange({
        leftField,
        right: this.props.join.right
      });
    });
    (0, _defineProperty2.default)(this, "_onRightSourceDescriptorChange", sourceDescriptor => {
      var _this$state$indexPatt;
      const indexPatternId = sourceDescriptor.indexPatternId;
      if (((_this$state$indexPatt = this.state.indexPattern) === null || _this$state$indexPatt === void 0 ? void 0 : _this$state$indexPatt.id) !== indexPatternId) {
        this.setState({
          indexPattern: undefined,
          rightFields: [],
          loadError: undefined
        });
        if (indexPatternId) {
          this._loadRightFields(indexPatternId);
        }
      }
      this.props.onChange({
        leftField: this.props.join.leftField,
        right: {
          ...sourceDescriptor
        }
      });
    });
    (0, _defineProperty2.default)(this, "_onMetricsChange", metrics => {
      this.props.onChange({
        leftField: this.props.join.leftField,
        right: {
          ...this.props.join.right,
          metrics
        }
      });
    });
    (0, _defineProperty2.default)(this, "_onWhereQueryChange", whereQuery => {
      this.props.onChange({
        leftField: this.props.join.leftField,
        right: {
          ...this.props.join.right,
          whereQuery
        }
      });
    });
    (0, _defineProperty2.default)(this, "_onApplyGlobalQueryChange", applyGlobalQuery => {
      this.props.onChange({
        leftField: this.props.join.leftField,
        right: {
          ...this.props.join.right,
          applyGlobalQuery
        }
      });
    });
    (0, _defineProperty2.default)(this, "_onApplyGlobalTimeChange", applyGlobalTime => {
      this.props.onChange({
        leftField: this.props.join.leftField,
        right: {
          ...this.props.join.right,
          applyGlobalTime
        }
      });
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadRightFields(_lodash.default.get(this.props.join, 'right.indexPatternId'));
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadRightFields(indexPatternId) {
    if (!indexPatternId) {
      return;
    }
    this._nextIndexPatternId = indexPatternId;
    let indexPattern;
    try {
      indexPattern = await (0, _kibana_services.getIndexPatternService)().get(indexPatternId);
    } catch (err) {
      if (this._isMounted) {
        this.setState({
          loadError: (0, _i18n_getters.getDataViewNotFoundMessage)(indexPatternId)
        });
      }
      return;
    }
    if (!this._isMounted || this._nextIndexPatternId !== indexPatternId) {
      return;
    }
    this.setState({
      rightFields: indexPattern.fields.filter(field => !_public.indexPatterns.isNestedField(field)),
      indexPattern
    });
  }
  render() {
    var _join$right;
    const {
      join,
      onRemove,
      leftFields,
      leftSourceName
    } = this.props;
    const {
      rightFields,
      indexPattern
    } = this.state;
    const right = (_join$right = join === null || join === void 0 ? void 0 : join.right) !== null && _join$right !== void 0 ? _join$right : {};
    let isJoinConfigComplete = false;
    let joinExpression;
    if (right.type === _constants.SOURCE_TYPES.ES_TERM_SOURCE) {
      isJoinConfigComplete = join.leftField !== undefined && (0, _join_sources.isTermSourceComplete)(right);
      joinExpression = /*#__PURE__*/_react.default.createElement(_term_join_expression.TermJoinExpression, {
        leftSourceName: leftSourceName,
        leftValue: join.leftField,
        leftFields: leftFields,
        onLeftFieldChange: this._onLeftFieldChange,
        sourceDescriptor: right,
        onSourceDescriptorChange: this._onRightSourceDescriptorChange,
        rightFields: rightFields,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 181,
          columnNumber: 9
        }
      });
    } else if ((0, _is_spatial_join.isSpatialJoin)(this.props.join)) {
      isJoinConfigComplete = join.leftField !== undefined && (0, _join_sources.isSpatialSourceComplete)(right);
      joinExpression = /*#__PURE__*/_react.default.createElement(_spatial_join_expression.SpatialJoinExpression, {
        sourceDescriptor: right,
        onSourceDescriptorChange: this._onRightSourceDescriptorChange,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 196,
          columnNumber: 9
        }
      });
    } else {
      joinExpression = /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 203,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 204,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
        color: "warning",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 205,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.maps.layerPanel.join.joinExpression.noEditorMsg', {
        defaultMessage: 'Unable to edit {type} join.',
        values: {
          type: right.type
        }
      }))));
    }
    let metricsExpression;
    let globalFilterCheckbox;
    let globalTimeCheckbox;
    if (isJoinConfigComplete) {
      metricsExpression = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 222,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_metrics_expression.MetricsExpression, {
        metrics: right.metrics ? right.metrics : [{
          type: _constants.AGG_TYPE.COUNT
        }],
        rightFields: rightFields,
        onChange: this._onMetricsChange,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 223,
          columnNumber: 11
        }
      }));
      globalFilterCheckbox = /*#__PURE__*/_react.default.createElement(_global_filter_checkbox.GlobalFilterCheckbox, {
        applyGlobalQuery: typeof right.applyGlobalQuery === 'undefined' ? true : right.applyGlobalQuery,
        setApplyGlobalQuery: this._onApplyGlobalQueryChange,
        label: _i18n.i18n.translate('xpack.maps.layerPanel.join.applyGlobalQueryCheckboxLabel', {
          defaultMessage: `Apply global search to join`
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 231,
          columnNumber: 9
        }
      });
      if (this.state.indexPattern && this.state.indexPattern.timeFieldName) {
        globalTimeCheckbox = /*#__PURE__*/_react.default.createElement(_global_time_checkbox.GlobalTimeCheckbox, {
          applyGlobalTime: typeof right.applyGlobalTime === 'undefined' ? true : right.applyGlobalTime,
          setApplyGlobalTime: this._onApplyGlobalTimeChange,
          label: _i18n.i18n.translate('xpack.maps.layerPanel.join.applyGlobalTimeCheckboxLabel', {
            defaultMessage: `Apply global time to join`
          }),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 243,
            columnNumber: 11
          }
        });
      }
    }
    let whereExpression;
    if (indexPattern && isJoinConfigComplete) {
      whereExpression = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 259,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_where_expression.WhereExpression, {
        indexPattern: indexPattern,
        whereQuery: right.whereQuery,
        onChange: this._onWhereQueryChange,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 260,
          columnNumber: 11
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "mapJoinItem",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 270,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      className: "mapJoinItem__inner",
      responsive: false,
      wrap: true,
      gutterSize: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 271,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 272,
        columnNumber: 11
      }
    }, joinExpression), metricsExpression, whereExpression), globalFilterCheckbox, globalTimeCheckbox, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      className: "mapJoinItem__delete",
      iconType: "trash",
      color: "danger",
      "aria-label": _i18n.i18n.translate('xpack.maps.layerPanel.join.deleteJoinAriaLabel', {
        defaultMessage: 'Delete join'
      }),
      title: _i18n.i18n.translate('xpack.maps.layerPanel.join.deleteJoinTitle', {
        defaultMessage: 'Delete join'
      }),
      onClick: onRemove,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 283,
        columnNumber: 9
      }
    }));
  }
}
exports.Join = Join;