"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LabelPositionEditor = LabelPositionEditor;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _get_vector_style_label = require("../get_vector_style_label");
var _constants = require("../../../../../../common/constants");
var _disabled_tooltip = require("../../disabled_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/styles/vector/components/label/label_position_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const options = [{
  value: _constants.LABEL_POSITIONS.TOP,
  text: _i18n.i18n.translate('xpack.maps.styles.labelPosition.top', {
    defaultMessage: 'Top'
  })
}, {
  value: _constants.LABEL_POSITIONS.CENTER,
  text: _i18n.i18n.translate('xpack.maps.styles.labelPosition.center', {
    defaultMessage: 'Center'
  })
}, {
  value: _constants.LABEL_POSITIONS.BOTTOM,
  text: _i18n.i18n.translate('xpack.maps.styles.labelBorderSize.bottom', {
    defaultMessage: 'Bottom'
  })
}];
function LabelPositionEditor({
  hasLabel,
  handlePropertyChange,
  styleProperty
}) {
  function onChange(e) {
    handlePropertyChange(styleProperty.getStyleName(), {
      options: {
        position: e.target.value
      }
    });
  }
  const disabled = !hasLabel || styleProperty.isDisabled();
  const form = /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: (0, _get_vector_style_label.getVectorStyleLabel)(_constants.VECTOR_STYLES.LABEL_POSITION),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    disabled: disabled,
    options: options,
    value: disabled ? _constants.LABEL_POSITIONS.CENTER : styleProperty.getOptions().position,
    onChange: onChange,
    "aria-label": _i18n.i18n.translate('xpack.maps.styles.labelPositionSelect.ariaLabel', {
      defaultMessage: 'Select label position'
    }),
    compressed: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 7
    }
  }));
  return !disabled ? form : /*#__PURE__*/_react.default.createElement(_disabled_tooltip.DisabledToolTip, {
    content: !hasLabel ? (0, _get_vector_style_label.getDisabledByMessage)(_constants.VECTOR_STYLES.LABEL_TEXT) : styleProperty.getDisabledReason(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 5
    }
  }, form);
}