"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateSourceEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _single_field_select = require("../../../components/single_field_select");
var _geo_index_pattern_select = require("../../../components/geo_index_pattern_select");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _index_pattern_util = require("../../../index_pattern_util");
var _render_as_select = require("./render_as_select");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/classes/sources/es_geo_grid_source/create_source_editor.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function doesNotSupportGeoTileAgg(field) {
  return !(0, _index_pattern_util.supportsGeoTileAgg)(field);
}
class CreateSourceEditor extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "state", {
      indexPattern: null,
      geoField: '',
      requestType: this.props.requestType
    });
    (0, _defineProperty2.default)(this, "onIndexPatternSelect", indexPattern => {
      this.setState({
        indexPattern
      }, () => {
        //make default selection
        const geoFieldsWithGeoTileAgg = (0, _index_pattern_util.getFieldsWithGeoTileAgg)(indexPattern.fields);
        if (geoFieldsWithGeoTileAgg[0]) {
          this._onGeoFieldSelect(geoFieldsWithGeoTileAgg[0].name);
        }
      });
    });
    (0, _defineProperty2.default)(this, "_onGeoFieldSelect", geoFieldName => {
      this.setState({
        geoField: geoFieldName
      }, this.previewLayer);
    });
    (0, _defineProperty2.default)(this, "_onRequestTypeSelect", newValue => {
      this.setState({
        requestType: newValue
      }, this.previewLayer);
    });
    (0, _defineProperty2.default)(this, "previewLayer", () => {
      const {
        indexPattern,
        geoField,
        requestType
      } = this.state;
      const sourceConfig = indexPattern && geoField ? {
        indexPatternId: indexPattern.id,
        geoField,
        requestType
      } : null;
      this.props.onSourceConfigChange(sourceConfig);
    });
  }
  _renderGeoSelect() {
    if (!this.state.indexPattern) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.maps.source.esGeoGrid.geofieldLabel', {
        defaultMessage: 'Cluster field'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, {
      placeholder: _i18n.i18n.translate('xpack.maps.source.esGeoGrid.geofieldPlaceholder', {
        defaultMessage: 'Select geo field'
      }),
      value: this.state.geoField,
      onChange: this._onGeoFieldSelect,
      fields: this.state.indexPattern ? (0, _index_pattern_util.getGeoFields)(this.state.indexPattern.fields) : undefined,
      isFieldDisabled: doesNotSupportGeoTileAgg,
      getFieldDisabledReason: _index_pattern_util.getGeoTileAggNotSupportedReason,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 9
      }
    }));
  }
  _renderRenderAsSelect() {
    if (!this.state.indexPattern) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_render_as_select.RenderAsSelect, {
      renderAs: this.state.requestType,
      onChange: this._onRequestTypeSelect,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 7
      }
    });
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_geo_index_pattern_select.GeoIndexPatternSelect, {
      dataView: this.state.indexPattern,
      onChange: this.onIndexPatternSelect,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 9
      }
    }), this._renderGeoSelect(), this._renderRenderAsSelect());
  }
}
exports.CreateSourceEditor = CreateSourceEditor;
(0, _defineProperty2.default)(CreateSourceEditor, "propTypes", {
  onSourceConfigChange: _propTypes.default.func.isRequired
});