"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsLocatorDefinition = exports.LOGS_LOCATOR_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _src = require("@kbn/discover-utils/src");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Locator used to link to all log sources in Discover.
 */
const LOGS_LOCATOR_ID = exports.LOGS_LOCATOR_ID = 'LOGS_LOCATOR';

/**
 * Accepts the same parameters as `DiscoverAppLocatorParams`, but automatically sets the `dataViewId` param to all log sources.
 */

class LogsLocatorDefinition {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "id", LOGS_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const discoverAppLocator = this.deps.locators.get('DISCOVER_APP_LOCATOR');
      return discoverAppLocator.getLocation({
        dataViewId: _src.ALL_LOGS_DATA_VIEW_ID,
        ...params
      });
    });
    this.deps = deps;
  }
}
exports.LogsLocatorDefinition = LogsLocatorDefinition;