"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PieToolbar = PieToolbar;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _charts = require("@elastic/charts");
var _public = require("@kbn/visualizations-plugin/public");
var _visualizationUtils = require("@kbn/visualization-utils");
var _constants = require("./constants");
var _partition_charts_meta = require("./partition_charts_meta");
var _types = require("../../../common/types");
var _constants2 = require("../../../common/constants");
var _shared_components = require("../../shared_components");
var _datasource_default_values = require("../../shared_components/datasource_default_values");
var _render_helpers = require("./render_helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/visualizations/partition/toolbar.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const partitionLegendValues = [{
  value: _charts.LegendValue.Value,
  label: _i18n.i18n.translate('xpack.lens.shared.legendValues.value', {
    defaultMessage: 'Value'
  })
}];
const legendOptions = [{
  id: 'pieLegendDisplay-default',
  value: _constants2.LegendDisplay.DEFAULT,
  label: _i18n.i18n.translate('xpack.lens.pieChart.legendVisibility.auto', {
    defaultMessage: 'Auto'
  })
}, {
  id: 'pieLegendDisplay-show',
  value: _constants2.LegendDisplay.SHOW,
  label: _i18n.i18n.translate('xpack.lens.pieChart.legendVisibility.show', {
    defaultMessage: 'Show'
  })
}, {
  id: 'pieLegendDisplay-hide',
  value: _constants2.LegendDisplay.HIDE,
  label: _i18n.i18n.translate('xpack.lens.pieChart.legendVisibility.hide', {
    defaultMessage: 'Hide'
  })
}];
const PANEL_STYLE = {
  width: '500px'
};
const emptySizeRatioLabel = _i18n.i18n.translate('xpack.lens.pieChart.donutHole', {
  defaultMessage: 'Donut hole'
});
function PieToolbar(props) {
  var _layer$percentDecimal, _PartitionChartsMeta$, _PartitionChartsMeta$2, _layer$secondaryGroup, _layer$secondaryGroup2, _layer$truncateLegend2;
  const {
    state,
    setState,
    frame
  } = props;
  const layer = state.layers[0];
  const {
    categoryOptions,
    numberOptions,
    emptySizeRatioOptions,
    isDisabled: isToolbarPopoverDisabled
  } = _partition_charts_meta.PartitionChartsMeta[state.shape].toolbarPopover;
  const legendSize = layer.legendSize;
  const [hadAutoLegendSize] = (0, _react.useState)(() => legendSize === _public.LegendSize.AUTO);
  const onStateChange = (0, _react.useCallback)(part => {
    setState({
      ...state,
      layers: [{
        ...layer,
        ...part
      }]
    });
  }, [layer, state, setState]);
  const onCategoryDisplayChange = (0, _react.useCallback)(option => onStateChange({
    categoryDisplay: option
  }), [onStateChange]);
  const onNumberDisplayChange = (0, _react.useCallback)(option => onStateChange({
    numberDisplay: option
  }), [onStateChange]);
  const onPercentDecimalsChange = (0, _react.useCallback)(option => {
    onStateChange({
      percentDecimals: option
    });
  }, [onStateChange]);
  const onLegendDisplayChange = (0, _react.useCallback)(optionId => {
    onStateChange({
      legendDisplay: legendOptions.find(({
        id
      }) => id === optionId).value
    });
  }, [onStateChange]);
  const onLegendPositionChange = (0, _react.useCallback)(id => onStateChange({
    legendPosition: id
  }), [onStateChange]);
  const onNestedLegendChange = (0, _react.useCallback)(id => onStateChange({
    nestedLegend: !layer.nestedLegend
  }), [layer, onStateChange]);
  const onTruncateLegendChange = (0, _react.useCallback)(() => {
    var _layer$truncateLegend;
    const current = (_layer$truncateLegend = layer.truncateLegend) !== null && _layer$truncateLegend !== void 0 ? _layer$truncateLegend : true;
    onStateChange({
      truncateLegend: !current
    });
  }, [layer, onStateChange]);
  const onLegendMaxLinesChange = (0, _react.useCallback)(val => onStateChange({
    legendMaxLines: val
  }), [onStateChange]);
  const onLegendSizeChange = (0, _react.useCallback)(val => onStateChange({
    legendSize: val
  }), [onStateChange]);
  const onLegendStatsChange = (0, _react.useCallback)(legendStats => {
    onStateChange({
      legendStats
    });
  }, [onStateChange]);
  const onEmptySizeRatioChange = (0, _react.useCallback)(([option]) => {
    if (option.value === 'none') {
      setState({
        ...state,
        shape: 'pie',
        layers: [{
          ...layer,
          emptySizeRatio: undefined
        }]
      });
    } else {
      var _emptySizeRatioOption;
      const emptySizeRatio = emptySizeRatioOptions === null || emptySizeRatioOptions === void 0 ? void 0 : (_emptySizeRatioOption = emptySizeRatioOptions.find(({
        id
      }) => id === option.value)) === null || _emptySizeRatioOption === void 0 ? void 0 : _emptySizeRatioOption.value;
      setState({
        ...state,
        shape: 'donut',
        layers: [{
          ...layer,
          emptySizeRatio
        }]
      });
    }
  }, [emptySizeRatioOptions, layer, setState, state]);
  const selectedOption = emptySizeRatioOptions ? emptySizeRatioOptions.find(({
    value
  }) => {
    var _layer$emptySizeRatio;
    return value === (state.shape === 'pie' ? 0 : (_layer$emptySizeRatio = layer.emptySizeRatio) !== null && _layer$emptySizeRatio !== void 0 ? _layer$emptySizeRatio : _types.EmptySizeRatios.SMALL);
  }) : undefined;
  if (!layer) {
    return null;
  }
  const defaultTruncationValue = (0, _datasource_default_values.getDefaultVisualValuesForLayer)(state, frame.datasourceLayers).truncateText;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 192,
      columnNumber: 5
    }
  }, emptySizeRatioOptions !== null && emptySizeRatioOptions !== void 0 && emptySizeRatioOptions.length && selectedOption ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 194,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.pieChart.appearanceLabel', {
      defaultMessage: 'Appearance'
    }),
    type: "visualOptions",
    buttonDataTestSubj: "lnsVisualOptionsButton",
    "data-test-subj": "lnsVisualOptionsPopover",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 195,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: emptySizeRatioLabel,
    display: "columnCompressed",
    fullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    compressed: true,
    "data-test-subj": "lnsEmptySizeRatioOption",
    "aria-label": _i18n.i18n.translate('xpack.lens.pieChart.donutHole', {
      defaultMessage: 'Donut hole'
    }),
    onChange: onEmptySizeRatioChange,
    isClearable: false,
    options: emptySizeRatioOptions.map(({
      id,
      label,
      icon
    }) => ({
      value: id,
      label,
      prepend: icon ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: icon,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 216,
          columnNumber: 35
        }
      }) : undefined
    })),
    selectedOptions: [{
      value: selectedOption.id,
      label: selectedOption.label
    }],
    singleSelection: {
      asPlainText: true
    },
    prepend: selectedOption !== null && selectedOption !== void 0 && selectedOption.icon ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: selectedOption.icon,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 220,
        columnNumber: 49
      }
    }) : undefined,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 15
    }
  })))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 226,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_components.ToolbarPopover, {
    title: _i18n.i18n.translate('xpack.lens.pieChart.titlesAndTextLabel', {
      defaultMessage: 'Titles and text'
    }),
    isDisabled: Boolean(isToolbarPopoverDisabled),
    type: "titlesAndText",
    panelStyle: PANEL_STYLE,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 9
    }
  }, categoryOptions.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.pieChart.labelSliceLabels', {
      defaultMessage: 'Slice labels'
    }),
    fullWidth: true,
    display: "columnCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.lens.pieChart.labelSliceLabels', {
      defaultMessage: 'Slice labels'
    }),
    options: categoryOptions,
    idSelected: layer.categoryDisplay,
    onChange: onCategoryDisplayChange,
    buttonSize: "compressed",
    isFullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 243,
      columnNumber: 15
    }
  })) : null, numberOptions.length && layer.categoryDisplay !== 'hide' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.lens.pieChart.sliceValues', {
      defaultMessage: 'Slice values'
    }),
    fullWidth: true,
    display: "columnCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.lens.pieChart.sliceValues', {
      defaultMessage: 'Slice values'
    }),
    options: numberOptions,
    idSelected: layer.numberDisplay,
    onChange: onNumberDisplayChange,
    buttonSize: "compressed",
    isFullWidth: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 265,
      columnNumber: 17
    }
  })), layer.numberDisplay === _constants2.NumberDisplay.PERCENT && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: " ",
    fullWidth: true,
    display: "columnCompressed",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 277,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(DecimalPlaceInput, {
    value: (_layer$percentDecimal = layer.percentDecimals) !== null && _layer$percentDecimal !== void 0 ? _layer$percentDecimal : _constants.DEFAULT_PERCENT_DECIMALS,
    setValue: onPercentDecimalsChange,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 19
    }
  }))) : null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 288,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_shared_components.LegendSettingsPopover, {
    groupPosition: 'none',
    legendOptions: legendOptions,
    mode: layer.legendDisplay,
    onDisplayChange: onLegendDisplayChange,
    legendStats: (0, _render_helpers.getLegendStats)(layer, state.shape),
    allowedLegendStats: (_PartitionChartsMeta$ = _partition_charts_meta.PartitionChartsMeta[state.shape]) !== null && _PartitionChartsMeta$ !== void 0 && _PartitionChartsMeta$.legend.defaultLegendStats ? partitionLegendValues : undefined,
    onLegendStatsChange: onLegendStatsChange,
    position: layer.legendPosition,
    onPositionChange: onLegendPositionChange,
    renderNestedLegendSwitch: !((_PartitionChartsMeta$2 = _partition_charts_meta.PartitionChartsMeta[state.shape]) !== null && _PartitionChartsMeta$2 !== void 0 && _PartitionChartsMeta$2.legend.hideNestedLegendSwitch) && layer.primaryGroups.length + ((_layer$secondaryGroup = (_layer$secondaryGroup2 = layer.secondaryGroups) === null || _layer$secondaryGroup2 === void 0 ? void 0 : _layer$secondaryGroup2.length) !== null && _layer$secondaryGroup !== void 0 ? _layer$secondaryGroup : 0) > 1,
    nestedLegend: Boolean(layer.nestedLegend),
    onNestedLegendChange: onNestedLegendChange,
    shouldTruncate: (_layer$truncateLegend2 = layer.truncateLegend) !== null && _layer$truncateLegend2 !== void 0 ? _layer$truncateLegend2 : defaultTruncationValue,
    onTruncateLegendChange: onTruncateLegendChange,
    maxLines: layer === null || layer === void 0 ? void 0 : layer.legendMaxLines,
    onMaxLinesChange: onLegendMaxLinesChange,
    legendSize: legendSize,
    onLegendSizeChange: onLegendSizeChange,
    showAutoLegendSizeOption: hadAutoLegendSize,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 289,
      columnNumber: 9
    }
  })));
}
const DecimalPlaceInput = ({
  value,
  setValue
}) => {
  const {
    inputValue,
    handleInputChange
  } = (0, _visualizationUtils.useDebouncedValue)({
    value,
    onChange: setValue
  }, {
    allowFalsyValue: true
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    "data-test-subj": "indexPattern-dimension-formatDecimals",
    value: inputValue,
    min: 0,
    max: 10,
    prepend: _i18n.i18n.translate('xpack.lens.pieChart.decimalPlaces', {
      defaultMessage: 'Decimal places'
    }),
    compressed: true,
    onChange: e => {
      handleInputChange(Number(e.currentTarget.value));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 337,
      columnNumber: 5
    }
  });
};