"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FormulaEditor = FormulaEditor;
exports.WrappedFormulaEditor = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _languageDocumentation = require("@kbn/language-documentation");
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _useUnmount = _interopRequireDefault(require("react-use/lib/useUnmount"));
var _monaco = require("@kbn/monaco");
var _codeEditor = require("@kbn/code-editor");
var _public = require("@kbn/data-plugin/public");
var _shared_components = require("../../../../../../shared_components");
var _layer_helpers = require("../../../layer_helpers");
var _validation = require("../validation");
var _math_completion = require("./math_completion");
var _math_tokenization = require("./math_tokenization");
var _parse = require("../parse");
var _util = require("../util");
var _time_shift_utils = require("../../../../time_shift_utils");
var _formula_help = require("./formula_help");
var _utils = require("../../../../../../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/lens/public/datasources/form_based/operations/definitions/formula/editor/formula_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function tableHasData(activeData, layerId, columnId) {
  const table = activeData === null || activeData === void 0 ? void 0 : activeData[layerId];
  if (!table || table.rows.length === 0) {
    return false;
  }
  return table.rows.some(row => row[columnId] != null);
}
const WrappedFormulaEditor = ({
  activeData,
  ...rest
}) => {
  const dateHistogramInterval = (0, _time_shift_utils.getDateHistogramInterval)(rest.data.datatableUtilities, rest.layer, rest.indexPattern, activeData, rest.layerId);
  return /*#__PURE__*/_react.default.createElement(MemoizedFormulaEditor, (0, _extends2.default)({}, rest, {
    dateHistogramInterval: dateHistogramInterval,
    hasData: tableHasData(activeData, rest.layerId, rest.columnId),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 5
    }
  }));
};
exports.WrappedFormulaEditor = WrappedFormulaEditor;
const MemoizedFormulaEditor = /*#__PURE__*/_react.default.memo(FormulaEditor);
const namedArgumentsTypes = new Set(['kql', 'lucene', 'shift', 'reducedTimeRange']);
function FormulaEditor({
  layer,
  paramEditorUpdater,
  currentColumn,
  columnId,
  indexPattern,
  operationDefinitionMap,
  unifiedSearch,
  dataViews,
  toggleFullscreen,
  isFullscreen,
  dateHistogramInterval,
  hasData,
  dateRange,
  uiSettings,
  data
}) {
  var _dateHistogramInterva;
  const [text, setText] = (0, _react.useState)(currentColumn.params.formula);
  const [warnings, setWarnings] = (0, _react.useState)([]);
  const [isHelpOpen, setIsHelpOpen] = (0, _react.useState)(isFullscreen);
  const [isWarningOpen, setIsWarningOpen] = (0, _react.useState)(false);
  const [isWordWrapped, toggleWordWrap] = (0, _react.useState)(true);
  const editorModel = _react.default.useRef();
  const overflowDiv1 = _react.default.useRef();
  const disposables = _react.default.useRef([]);
  const editor1 = _react.default.useRef();
  const euiThemeContext = (0, _eui.useEuiTheme)();
  const {
    euiTheme
  } = euiThemeContext;
  const visibleOperationsMap = (0, _react.useMemo)(() => (0, _util.filterByVisibleOperation)(operationDefinitionMap), [operationDefinitionMap]);
  const documentationSections = (0, _react.useMemo)(() => (0, _formula_help.getDocumentationSections)({
    indexPattern,
    operationDefinitionMap: visibleOperationsMap
  }), [indexPattern, visibleOperationsMap]);
  const baseInterval = 'interval' in dateHistogramInterval ? (_dateHistogramInterva = dateHistogramInterval.interval) === null || _dateHistogramInterva === void 0 ? void 0 : _dateHistogramInterva.asMilliseconds() : undefined;
  const baseIntervalRef = (0, _react.useRef)(baseInterval);
  baseIntervalRef.current = baseInterval;

  // The Monaco editor needs to have the overflowDiv in the first render. Using an effect
  // requires a second render to work, so we are using an if statement to guarantee it happens
  // on first render
  if (!(overflowDiv1 !== null && overflowDiv1 !== void 0 && overflowDiv1.current)) {
    const node1 = overflowDiv1.current = document.createElement('div');
    node1.setAttribute('data-test-subj', 'lnsFormulaWidget');
    // Monaco CSS is targeted on the monaco-editor class
    node1.classList.add('lnsFormulaOverflow', 'monaco-editor');
    document.body.appendChild(node1);
  }

  // Clean up the monaco editor and DOM on unmount
  (0, _react.useEffect)(() => {
    const model = editorModel;
    const allDisposables = disposables;
    const editor1ref = editor1;
    return () => {
      var _model$current, _overflowDiv1$current, _overflowDiv1$current2, _editor1ref$current, _allDisposables$curre;
      (_model$current = model.current) === null || _model$current === void 0 ? void 0 : _model$current.dispose();
      (_overflowDiv1$current = overflowDiv1.current) === null || _overflowDiv1$current === void 0 ? void 0 : (_overflowDiv1$current2 = _overflowDiv1$current.parentNode) === null || _overflowDiv1$current2 === void 0 ? void 0 : _overflowDiv1$current2.removeChild(overflowDiv1.current);
      (_editor1ref$current = editor1ref.current) === null || _editor1ref$current === void 0 ? void 0 : _editor1ref$current.dispose();
      (_allDisposables$curre = allDisposables.current) === null || _allDisposables$curre === void 0 ? void 0 : _allDisposables$curre.forEach(d => d.dispose());
    };
  }, []);
  (0, _useUnmount.default)(() => {
    // If the text is not synced, update the column.
    if (text !== currentColumn.params.formula) {
      paramEditorUpdater(prevLayer => (0, _parse.insertOrReplaceFormulaColumn)(columnId, {
        ...currentColumn,
        params: {
          ...currentColumn.params,
          formula: text || ''
        }
      }, prevLayer, {
        indexPattern,
        operations: operationDefinitionMap,
        dateRange
      }).layer);
    }
  });
  (0, _shared_components.useDebounceWithOptions)(() => {
    if (!editorModel.current) return;
    if (!text) {
      setWarnings([]);
      _monaco.monaco.editor.setModelMarkers(editorModel.current, 'LENS', []);
      if (currentColumn.params.formula) {
        // Only submit if valid
        paramEditorUpdater((0, _parse.insertOrReplaceFormulaColumn)(columnId, {
          ...currentColumn,
          params: {
            ...currentColumn.params,
            formula: text || ''
          }
        }, layer, {
          indexPattern,
          operations: operationDefinitionMap,
          dateRange
        }).layer);
      }
      return;
    }
    let errors = [];
    const parseResponse = (0, _validation.tryToParse)(text, visibleOperationsMap);
    if ('error' in parseResponse) {
      errors = [parseResponse.error];
    } else {
      const validationErrors = (0, _validation.runASTValidation)(parseResponse.root, layer, indexPattern, visibleOperationsMap, currentColumn, dateRange);
      if (validationErrors.length) {
        errors = validationErrors;
      }
    }
    if (errors.length) {
      // Replace the previous error with the new one
      const previousFormulaWasBroken = currentColumn.params.isFormulaBroken;
      // If the user is changing a previous formula and there are currently no result
      // show the most up-to-date state with the error message.
      const previousFormulaWasOkButNoData = !currentColumn.params.isFormulaBroken && !hasData;
      if (previousFormulaWasBroken || previousFormulaWasOkButNoData) {
        // If the formula is already broken, show the latest error message in the workspace
        if (currentColumn.params.formula !== text) {
          paramEditorUpdater((0, _parse.insertOrReplaceFormulaColumn)(columnId, {
            ...currentColumn,
            params: {
              ...currentColumn.params,
              formula: text || ''
            }
          }, layer, {
            indexPattern,
            operations: operationDefinitionMap,
            dateRange
          }).layer);
        }
      }
      const markers = errors.flatMap(innerError => {
        if (innerError.locations.length) {
          return innerError.locations.map(location => {
            const startPosition = (0, _math_completion.offsetToRowColumn)(text, location.min);
            const endPosition = (0, _math_completion.offsetToRowColumn)(text, location.max);
            return {
              message: innerError.message,
              startColumn: startPosition.column + 1,
              startLineNumber: startPosition.lineNumber,
              endColumn: endPosition.column + 1,
              endLineNumber: endPosition.lineNumber,
              severity: innerError.severity === 'warning' ? _monaco.monaco.MarkerSeverity.Warning : _monaco.monaco.MarkerSeverity.Error
            };
          });
        } else {
          // Parse errors return no location info
          const startPosition = (0, _math_completion.offsetToRowColumn)(text, 0);
          const endPosition = (0, _math_completion.offsetToRowColumn)(text, text.length - 1);
          return [{
            message: innerError.message,
            startColumn: startPosition.column + 1,
            startLineNumber: startPosition.lineNumber,
            endColumn: endPosition.column + 1,
            endLineNumber: endPosition.lineNumber,
            severity: innerError.severity === 'warning' ? _monaco.monaco.MarkerSeverity.Warning : _monaco.monaco.MarkerSeverity.Error
          }];
        }
      });
      _monaco.monaco.editor.setModelMarkers(editorModel.current, 'LENS', markers);
      setWarnings(markers.map(({
        severity,
        message
      }) => ({
        severity,
        message
      })));
    } else {
      _monaco.monaco.editor.setModelMarkers(editorModel.current, 'LENS', []);

      // Only submit if valid
      const {
        layer: newLayer,
        meta: {
          locations
        }
      } = (0, _parse.insertOrReplaceFormulaColumn)(columnId, {
        ...currentColumn,
        params: {
          ...currentColumn.params,
          formula: text || ''
        }
      }, layer, {
        indexPattern,
        operations: operationDefinitionMap,
        dateRange
      });
      paramEditorUpdater(newLayer);
      const managedColumns = (0, _layer_helpers.getManagedColumnsFrom)(columnId, newLayer.columns);
      const markers = managedColumns.flatMap(([id, column]) => {
        const newWarnings = [];
        if (locations[id]) {
          const def = visibleOperationsMap[column.operationType];
          if (def.getErrorMessage) {
            const messages = def.getErrorMessage(newLayer, id, indexPattern, dateRange, visibleOperationsMap, uiSettings.get(_public.UI_SETTINGS.HISTOGRAM_BAR_TARGET));
            if (messages.length) {
              const startPosition = (0, _math_completion.offsetToRowColumn)(text, locations[id].min);
              const endPosition = (0, _math_completion.offsetToRowColumn)(text, locations[id].max);
              newWarnings.push({
                message: messages.map(e => e.message).join(', '),
                startColumn: startPosition.column + 1,
                startLineNumber: startPosition.lineNumber,
                endColumn: endPosition.column + 1,
                endLineNumber: endPosition.lineNumber,
                severity: _monaco.monaco.MarkerSeverity.Warning
              });
            }
          }
          if (def.shiftable && column.timeShift) {
            const startPosition = (0, _math_completion.offsetToRowColumn)(text, locations[id].min);
            const endPosition = (0, _math_completion.offsetToRowColumn)(text, locations[id].max);
            newWarnings.push(...(0, _time_shift_utils.getColumnTimeShiftWarnings)(dateHistogramInterval, column.timeShift).map(message => ({
              message,
              startColumn: startPosition.column + 1,
              startLineNumber: startPosition.lineNumber,
              endColumn: endPosition.column + 1,
              endLineNumber: endPosition.lineNumber,
              severity: _monaco.monaco.MarkerSeverity.Warning
            })));
          }
        }
        return newWarnings;
      }).filter(_utils.nonNullable);
      setWarnings(markers.map(({
        severity,
        message
      }) => ({
        severity,
        message
      })));
      _monaco.monaco.editor.setModelMarkers(editorModel.current, 'LENS', markers);
    }
  },
  // Make it validate on flyout open in case of a broken formula left over
  // from a previous edit
  {
    skipFirstRender: false
  }, 256, [text, currentColumn.filter]);
  const errorCount = warnings.filter(marker => marker.severity === _monaco.monaco.MarkerSeverity.Error).length;
  const warningCount = warnings.filter(marker => marker.severity === _monaco.monaco.MarkerSeverity.Warning).length;

  /**
   * The way that Monaco requests autocompletion is not intuitive, but the way we use it
   * we fetch new suggestions in these scenarios:
   *
   * - If the user types one of the trigger characters, suggestions are always fetched
   * - When the user selects the kql= suggestion, we tell Monaco to trigger new suggestions after
   * - When the user types the first character into an empty text box, Monaco requests suggestions
   *
   * Monaco also triggers suggestions automatically when there are no suggestions being displayed
   * and the user types a non-whitespace character.
   *
   * While suggestions are being displayed, Monaco uses an in-memory cache of the last known suggestions.
   */
  const provideCompletionItems = (0, _react.useCallback)(async (model, position, context) => {
    const innerText = model.getValue();
    let aSuggestions = {
      list: [],
      type: _math_completion.SUGGESTION_TYPE.FIELD
    };
    const offset = (0, _math_completion.monacoPositionToOffset)(innerText, position);
    if (context.triggerCharacter === '(') {
      // Monaco usually inserts the end quote and reports the position is after the end quote
      if (innerText.slice(offset - 1, offset + 1) === '()') {
        position = position.delta(0, -1);
      }
      const wordUntil = model.getWordAtPosition(position.delta(0, -3));
      if (wordUntil) {
        // Retrieve suggestions for subexpressions
        aSuggestions = await (0, _math_completion.suggest)({
          expression: innerText,
          zeroIndexedOffset: offset,
          context,
          indexPattern,
          operationDefinitionMap: visibleOperationsMap,
          unifiedSearch,
          dataViews,
          dateHistogramInterval: baseIntervalRef.current,
          timefilter: data.query.timefilter.timefilter
        });
      }
    } else {
      aSuggestions = await (0, _math_completion.suggest)({
        expression: innerText,
        zeroIndexedOffset: offset,
        context,
        indexPattern,
        operationDefinitionMap: visibleOperationsMap,
        unifiedSearch,
        dataViews,
        dateHistogramInterval: baseIntervalRef.current,
        timefilter: data.query.timefilter.timefilter
      });
    }
    return {
      suggestions: aSuggestions.list.map(s => (0, _math_completion.getSuggestion)(s, aSuggestions.type, visibleOperationsMap, context.triggerCharacter, aSuggestions.range))
    };
  }, [indexPattern, visibleOperationsMap, unifiedSearch, dataViews, data.query.timefilter.timefilter]);
  const provideSignatureHelp = (0, _react.useCallback)(async (model, position, token, context) => {
    const innerText = model.getValue();
    const textRange = model.getFullModelRange();
    const lengthAfterPosition = model.getValueLengthInRange({
      startLineNumber: position.lineNumber,
      startColumn: position.column,
      endLineNumber: textRange.endLineNumber,
      endColumn: textRange.endColumn
    });
    return (0, _math_completion.getSignatureHelp)(model.getValue(), innerText.length - lengthAfterPosition, visibleOperationsMap);
  }, [visibleOperationsMap]);
  const provideHover = (0, _react.useCallback)(async (model, position, token) => {
    const innerText = model.getValue();
    const textRange = model.getFullModelRange();
    const lengthAfterPosition = model.getValueLengthInRange({
      startLineNumber: position.lineNumber,
      startColumn: position.column,
      endLineNumber: textRange.endLineNumber,
      endColumn: textRange.endColumn
    });
    return (0, _math_completion.getHover)(model.getValue(), innerText.length - lengthAfterPosition, visibleOperationsMap);
  }, [visibleOperationsMap]);
  const onTypeHandler = (0, _react.useCallback)((e, editor) => {
    if (e.isFlush || e.isRedoing || e.isUndoing) {
      return;
    }
    if (e.changes.length === 1) {
      const char = e.changes[0].text;
      if (char !== '=' && char !== "'") {
        return;
      }
      const currentPosition = e.changes[0].range;
      if (currentPosition) {
        var _tokenInfo;
        const currentText = editor.getValue();
        const offset = (0, _math_completion.monacoPositionToOffset)(currentText, new _monaco.monaco.Position(currentPosition.startLineNumber, currentPosition.startColumn));
        let tokenInfo = (0, _math_completion.getTokenInfo)(currentText, offset + 1);
        if (!tokenInfo && char === "'") {
          // try again this time replacing the current quote with an escaped quote
          const line = currentText;
          const lineEscaped = line.substring(0, offset) + "\\'" + line.substring(offset + 1);
          tokenInfo = (0, _math_completion.getTokenInfo)(lineEscaped, offset + 2);
        }
        const isSingleQuoteCase = /'LENS_MATH_MARKER/;
        // Make sure that we are only adding kql='' or lucene='', and also
        // check that the = sign isn't inside the KQL expression like kql='='
        if (tokenInfo) {
          if (typeof tokenInfo.ast === 'number' || tokenInfo.ast.type !== 'namedArgument' || !namedArgumentsTypes.has(tokenInfo.ast.name) || tokenInfo.ast.value !== _math_completion.MARKER && !isSingleQuoteCase.test(tokenInfo.ast.value)) {
            return;
          }
        }
        let editOperation = null;
        const cursorOffset = 2;
        if (char === '=') {
          // check also the previous char whether it was already a =
          // to avoid infinite loops
          if (!tokenInfo && currentText.charAt(offset - 1) !== '=') {
            editOperation = (0, _math_completion.createEditOperation)('=', currentPosition, 1);
          }
          if (tokenInfo) {
            editOperation = (0, _math_completion.createEditOperation)(`''`, currentPosition, 1);
          }
        }
        if (!tokenInfo && !editOperation) {
          return;
        }
        if (char === "'" && (_tokenInfo = tokenInfo) !== null && _tokenInfo !== void 0 && _tokenInfo.ast && typeof tokenInfo.ast !== 'number' && 'name' in tokenInfo.ast && tokenInfo.ast.name !== 'shift' && tokenInfo.ast.name !== 'reducedTimeRange') {
          editOperation = (0, _math_completion.createEditOperation)(`\\'`, currentPosition);
        }
        if (editOperation) {
          setTimeout(() => {
            var _editOperation;
            editor.executeEdits('LENS', [editOperation], [
            // After inserting, move the cursor in between the single quotes or after the escaped quote
            new _monaco.monaco.Selection(currentPosition.startLineNumber, currentPosition.startColumn + cursorOffset, currentPosition.startLineNumber, currentPosition.startColumn + cursorOffset)]);

            // Need to move these sync to prevent race conditions between a fast user typing a single quote
            // after an = char
            // Timeout is required because otherwise the cursor position is not updated.
            editor.setPosition({
              column: currentPosition.startColumn + cursorOffset,
              lineNumber: currentPosition.startLineNumber
            });
            if (((_editOperation = editOperation) === null || _editOperation === void 0 ? void 0 : _editOperation.text) !== '=') {
              editor.trigger('lens', 'editor.action.triggerSuggest', {});
            }
          }, 0);
        }
      }
    }
  }, []);
  const codeEditorOptions = {
    languageId: _math_tokenization.LANGUAGE_ID,
    value: text !== null && text !== void 0 ? text : '',
    onChange: setText,
    options: {
      automaticLayout: true,
      fontSize: 14,
      folding: false,
      lineNumbers: 'off',
      scrollBeyondLastLine: false,
      minimap: {
        enabled: false
      },
      wordWrap: isWordWrapped ? 'on' : 'off',
      // Disable suggestions that appear when we don't provide a default suggestion
      wordBasedSuggestions: false,
      autoIndent: 'brackets',
      wrappingIndent: 'none',
      dimension: {
        width: 320,
        height: 200
      },
      fixedOverflowWidgets: true,
      matchBrackets: 'always',
      // Undocumented Monaco option to force left margin width
      lineDecorationsWidth: 16
    }
  };
  (0, _react.useEffect)(() => {
    // Because the monaco model is owned by Lens, we need to manually attach and remove handlers
    const {
      dispose: dispose1
    } = _monaco.monaco.languages.registerCompletionItemProvider(_math_tokenization.LANGUAGE_ID, {
      triggerCharacters: ['.', '(', '=', ' ', ':', `'`],
      provideCompletionItems
    });
    const {
      dispose: dispose2
    } = _monaco.monaco.languages.registerSignatureHelpProvider(_math_tokenization.LANGUAGE_ID, {
      signatureHelpTriggerCharacters: ['(', '='],
      provideSignatureHelp
    });
    const {
      dispose: dispose3
    } = _monaco.monaco.languages.registerHoverProvider(_math_tokenization.LANGUAGE_ID, {
      provideHover
    });
    return () => {
      dispose1();
      dispose2();
      dispose3();
    };
  }, [provideCompletionItems, provideSignatureHelp, provideHover]);

  // The Monaco editor will lazily load Monaco, which takes a render cycle to trigger. This can cause differences
  // in the behavior of Monaco when it's first loaded and then reloaded.
  return /*#__PURE__*/_react.default.createElement("div", {
    css: [sharedEditorStyles.self(euiThemeContext), isFullscreen ? fullscreenEditorStyles : defaultEditorStyles],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 689,
      columnNumber: 5
    }
  }, !isFullscreen && /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
    css: (0, _react2.css)`
            margin-top: ${euiTheme.size.base};
            margin-bottom: ${euiTheme.size.xs};
          `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 696,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.lens.indexPattern.dimensionEditor.headingFormula', {
    defaultMessage: 'Formula'
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsFormula",
    css: (0, _react2.css)({
      backgroundColor: euiTheme.colors.backgroundBaseSubdued,
      border: isFullscreen ? 'none' : euiTheme.border.thin,
      borderRadius: isFullscreen ? 0 : euiTheme.border.radius.medium,
      height: isFullscreen ? '100%' : 'auto'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 708,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsFormula__editor",
    css: (0, _react2.css)`
            & > * + * {
              border-top: ${euiTheme.border.thin};
            }
          `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 717,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: sharedEditorStyles.editorHeader(euiThemeContext),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 725,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 726,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
                  display: block;
                `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 727,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isWordWrapped ? _i18n.i18n.translate('xpack.lens.formula.disableWordWrapLabel', {
      defaultMessage: 'Disable word wrap'
    }) : _i18n.i18n.translate('xpack.lens.formulaEnableWordWrapLabel', {
      defaultMessage: 'Enable word wrap'
    }),
    position: "top",
    disableScreenReaderOutput: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 732,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: isWordWrapped ? 'wordWrap' : 'wordWrapDisabled',
    display: !isWordWrapped ? 'fill' : undefined,
    color: 'text',
    "aria-label": isWordWrapped ? _i18n.i18n.translate('xpack.lens.formula.disableWordWrapLabel', {
      defaultMessage: 'Disable word wrap'
    }) : _i18n.i18n.translate('xpack.lens.formulaEnableWordWrapLabel', {
      defaultMessage: 'Enable word wrap'
    }),
    isSelected: !isWordWrapped,
    onClick: () => {
      var _editor1$current;
      (_editor1$current = editor1.current) === null || _editor1$current === void 0 ? void 0 : _editor1$current.updateOptions({
        wordWrap: isWordWrapped ? 'off' : 'on'
      });
      toggleWordWrap(!isWordWrapped);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 745,
      columnNumber: 19
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react2.css)`
                  display: block;
                `,
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 769,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: () => {
      toggleFullscreen();
      // Help text opens when entering full screen, and closes when leaving full screen
      setIsHelpOpen(!isFullscreen);
    },
    iconType: isFullscreen ? 'fullScreenExit' : 'fullScreen',
    size: "xs",
    color: "text",
    flush: "right",
    "data-test-subj": "lnsFormula-fullscreen",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 775,
      columnNumber: 17
    }
  }, isFullscreen ? _i18n.i18n.translate('xpack.lens.formula.fullScreenExitLabel', {
    defaultMessage: 'Collapse'
  }) : _i18n.i18n.translate('xpack.lens.formula.fullScreenEnterLabel', {
    defaultMessage: 'Expand'
  }))))), /*#__PURE__*/_react.default.createElement("div", {
    className: "lnsFormula__editorContent",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 799,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, (0, _extends2.default)({}, codeEditorOptions, {
    transparentBackground: true,
    options: {
      ...codeEditorOptions.options,
      // Shared model and overflow node
      overflowWidgetsDomNode: overflowDiv1.current
    },
    editorDidMount: editor => {
      editor1.current = editor;
      const model = editor.getModel();
      if (model) {
        editorModel.current = model;
      }
      // If we ever introduce a second Monaco editor, we need to toggle
      // the typing handler to the active editor to maintain the cursor
      disposables.current.push(editor.onDidChangeModelContent(e => {
        onTypeHandler(e, editor);
      }));
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 800,
      columnNumber: 13
    }
  })), !text ? /*#__PURE__*/_react.default.createElement("div", {
    css: sharedEditorStyles.editorPlaceholder(euiThemeContext),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 825,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 826,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.lens.formulaPlaceholderText', {
    defaultMessage: 'Type a formula by combining functions with math, like:'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 831,
      columnNumber: 17
    }
  }), /*#__PURE__*/_react.default.createElement("pre", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 832,
      columnNumber: 17
    }
  }, "count() + 1")) : null), /*#__PURE__*/_react.default.createElement("div", {
    css: sharedEditorStyles.editorFooter(euiThemeContext),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 837,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "m",
    responsive: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 838,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 839,
      columnNumber: 15
    }
  }, isFullscreen ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: isHelpOpen ? _i18n.i18n.translate('xpack.lens.formula.editorHelpInlineHideToolTip', {
      defaultMessage: 'Hide function reference'
    }) : _i18n.i18n.translate('xpack.lens.formula.editorHelpInlineShowToolTip', {
      defaultMessage: 'Show function reference'
    }),
    delay: "long",
    position: "top",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 841,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "aria-label": _i18n.i18n.translate('xpack.lens.formula.editorHelpInlineHideLabel', {
      defaultMessage: 'Hide function reference'
    }),
    className: "lnsFormula__editorHelp lnsFormula__editorHelp--inline",
    css: sharedEditorStyles.editorHelpLink(euiThemeContext),
    color: "text",
    onClick: () => setIsHelpOpen(!isHelpOpen),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 854,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "documentation",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 863,
      columnNumber: 23
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: isHelpOpen ? 'arrowDown' : 'arrowUp',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 864,
      columnNumber: 23
    }
  }))) : /*#__PURE__*/_react.default.createElement(_languageDocumentation.LanguageDocumentationPopover, {
    language: "Formula",
    sections: documentationSections,
    buttonProps: {
      color: 'text',
      className: 'lnsFormula__editorHelp lnsFormula__editorHelp--overlay',
      'data-test-subj': 'ESQLEditor-documentation',
      'aria-label': _i18n.i18n.translate('xpack.lens.formula.editorHelpInlineShowToolTip', {
        defaultMessage: 'Show function reference'
      })
    },
    isHelpMenuOpen: isHelpOpen,
    onHelpMenuVisibilityChange: setIsHelpOpen,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 868,
      columnNumber: 19
    }
  })), errorCount || warningCount ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 889,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: false,
    isOpen: isWarningOpen,
    closePopover: () => setIsWarningOpen(false),
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      color: errorCount ? 'danger' : 'warning',
      css: (0, _react2.css)`
                          white-space: nowrap;
                        `,
      className: "lnsFormula__editorError",
      iconType: "warning",
      size: "xs",
      flush: "right",
      onClick: () => {
        setIsWarningOpen(!isWarningOpen);
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 895,
        columnNumber: 23
      }
    }, errorCount ? _i18n.i18n.translate('xpack.lens.formulaErrorCount', {
      defaultMessage: '{count} {count, plural, one {error} other {errors}}',
      values: {
        count: errorCount
      }
    }) : null, warningCount ? _i18n.i18n.translate('xpack.lens.formulaWarningCount', {
      defaultMessage: '{count} {count, plural, one {warning} other {warnings}}',
      values: {
        count: warningCount
      }
    }) : null),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 890,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
                        max-width: ${euiTheme.components.forms.maxWidth};
                      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 924,
      columnNumber: 21
    }
  }, warnings.map(({
    message,
    severity
  }, index) => /*#__PURE__*/_react.default.createElement("div", {
    key: index,
    css: index !== 0 && sharedEditorStyles.warningText(euiThemeContext),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 930,
      columnNumber: 25
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: severity === _monaco.monaco.MarkerSeverity.Warning ? 'warning' : 'danger',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 934,
      columnNumber: 27
    }
  }, message)))))) : null))), isFullscreen && isHelpOpen ? /*#__PURE__*/_react.default.createElement("div", {
    className: "documentation__docs--inline",
    css: sharedEditorStyles.formulaDocs(euiThemeContext),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 954,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_languageDocumentation.LanguageDocumentationPopoverContent, {
    language: "Formula",
    sections: documentationSections,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 958,
      columnNumber: 13
    }
  })) : null));
}
const sharedEditorStyles = {
  self: ({
    euiTheme
  }) => {
    return (0, _react2.css)`
      .lnsFormula {
        display: flex;
        flex-direction: column;

        & > * {
          flex: 1;
          min-height: 0;
        }

        & > * + * {
          border-top: ${euiTheme.border.thin};
        }
      }

      .lnsFormulaOverflow {
        // Needs to be higher than the modal and all flyouts
        z-index: ${euiTheme.levels.toast} + 1;
      }

      .lnsFormula__editorContent {
        background-color: ${euiTheme.colors.backgroundBasePlain};
        min-height: 0;
        position: relative;
      }
    `;
  },
  formulaDocs: ({
    euiTheme
  }) => (0, _react2.css)`
    display: flex;
    flex-direction: column;
    // make sure docs are rendered in front of monaco
    z-index: 1;
    background: ${euiTheme.colors.backgroundBasePlain};
  `,
  editorHeader: ({
    euiTheme
  }) => (0, _react2.css)`
    padding: ${euiTheme.size.s};
  `,
  editorFooter: ({
    euiTheme
  }) => (0, _react2.css)`
    padding: ${euiTheme.size.s};
    // make sure docs are rendered in front of monaco
    z-index: 1;
    border-bottom-right-radius: ${euiTheme.border.radius.medium};
    border-bottom-left-radius: ${euiTheme.border.radius.medium};
  `,
  editorPlaceholder: ({
    euiTheme
  }) => (0, _react2.css)`
    position: absolute;
    top: 0;
    left: ${euiTheme.size.base};
    right: 0;
    color: ${euiTheme.colors.textSubdued}
    // Matches monaco editor
    font-family: Menlo, Monaco, 'Courier New', monospace;
    pointer-events: none;
  `,
  warningText: ({
    euiTheme
  }) => (0, _react2.css)`
    margin-top: ${euiTheme.size.s};
    border-top: ${euiTheme.border.thin};
    padding-top: ${euiTheme.size.s};
  `,
  editorHelpLink: ({
    euiTheme
  }) => (0, _react2.css)`
    align-items: center;
    display: flex;
    padding: ${euiTheme.size.xs};

    & > * + * {
      margin-left: ${euiTheme.size.xs};
    }
  `
};
const defaultEditorStyles = (0, _react2.css)`
  .lnsFormula__editorContent {
    height: 200px;
  }
`;
const fullscreenEditorStyles = (0, _react2.css)`
  position: absolute;
  left: 0;
  right: 0;
  top: 0;
  bottom: 0;

  .lnsFormula__editor {
    border-bottom: none;
    display: flex;
    flex-direction: column;
  }

  .lnsFormula__editorContent {
    flex: 1;
  }
`;