"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InterceptTriggerService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/core/server");
var _saved_objects = require("../saved_objects");
var _intercepts_usage_collection = require("../usage_collection/intercepts_usage_collection");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class InterceptTriggerService {
  constructor() {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "counter", void 0);
    (0, _defineProperty2.default)(this, "savedObjectsClient", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "savedObjectRef", _saved_objects.interceptTriggerRecordSavedObject);
  }
  setup(core, {
    kibanaVersion,
    usageCollector,
    logger
  }) {
    this.logger = logger;
    this.kibanaVersion = kibanaVersion;
    this.counter = (0, _intercepts_usage_collection.getCounters)(usageCollector);
    core.savedObjects.registerType(this.savedObjectRef);
    return {
      fetchRegisteredTask: this.fetchRegisteredTask.bind(this)
    };
  }
  start(core) {
    this.savedObjectsClient = core.savedObjects.createInternalRepository([this.savedObjectRef.name]);
    return {
      registerTriggerDefinition: this.registerTriggerDefinition.bind(this)
    };
  }
  async fetchRegisteredTask(triggerId) {
    var _result$attributes, _result;
    let result;
    try {
      var _this$savedObjectsCli;
      result = await ((_this$savedObjectsCli = this.savedObjectsClient) === null || _this$savedObjectsCli === void 0 ? void 0 : _this$savedObjectsCli.get(_saved_objects.interceptTriggerRecordSavedObject.name, triggerId));
    } catch (err) {
      if (_server.SavedObjectsErrorHelpers.isNotFoundError(err)) {
        // If the task is not found, it means it's not registered yet, so we return null
        return null;
      } else {
        var _this$logger, _this$counter;
        (_this$logger = this.logger) === null || _this$logger === void 0 ? void 0 : _this$logger.error(`Error fetching registered task: ${err.message}`);
        (_this$counter = this.counter) === null || _this$counter === void 0 ? void 0 : _this$counter.errorCounter(`productInterceptTriggerRecordFetch:${triggerId}`);
        return null;
      }
    }
    return (_result$attributes = (_result = result) === null || _result === void 0 ? void 0 : _result.attributes) !== null && _result$attributes !== void 0 ? _result$attributes : null;
  }
  async registerTriggerDefinition(triggerId, cb) {
    const existingTriggerDefinition = await this.fetchRegisteredTask(triggerId);
    const {
      triggerAfter,
      isRecurrent
    } = cb({
      existingTriggerDefinition
    });
    if (!triggerAfter) {
      var _this$logger2;
      (_this$logger2 = this.logger) === null || _this$logger2 === void 0 ? void 0 : _this$logger2.error('Trigger interval is not defined');
      return;
    }
    if (!existingTriggerDefinition) {
      var _this$savedObjectsCli2;
      const contextName = `productInterceptTriggerCreation:${triggerId}`;
      await ((_this$savedObjectsCli2 = this.savedObjectsClient) === null || _this$savedObjectsCli2 === void 0 ? void 0 : _this$savedObjectsCli2.create(this.savedObjectRef.name, {
        firstRegisteredAt: new Date().toISOString(),
        triggerAfter,
        installedOn: this.kibanaVersion,
        recurrent: isRecurrent !== null && isRecurrent !== void 0 ? isRecurrent : true
      }, {
        id: triggerId
      }).then(result => {
        var _this$counter2;
        (_this$counter2 = this.counter) === null || _this$counter2 === void 0 ? void 0 : _this$counter2.usageCounter(contextName);
        return result;
      }).catch(err => {
        var _this$logger3, _this$counter3;
        (_this$logger3 = this.logger) === null || _this$logger3 === void 0 ? void 0 : _this$logger3.error(err.message);
        (_this$counter3 = this.counter) === null || _this$counter3 === void 0 ? void 0 : _this$counter3.errorCounter(contextName);
      }));
      return;
    } else if (
    // only support updating the trigger interval for existing trigger definitions
    existingTriggerDefinition && existingTriggerDefinition.triggerAfter !== triggerAfter) {
      var _this$savedObjectsCli3;
      const contextName = `productInterceptTriggerUpdate:${triggerId}`;
      await ((_this$savedObjectsCli3 = this.savedObjectsClient) === null || _this$savedObjectsCli3 === void 0 ? void 0 : _this$savedObjectsCli3.update(this.savedObjectRef.name, triggerId, {
        triggerAfter
      }).then(result => {
        var _this$counter4;
        (_this$counter4 = this.counter) === null || _this$counter4 === void 0 ? void 0 : _this$counter4.usageCounter(contextName);
        return result;
      }).catch(err => {
        var _this$logger4, _this$counter5;
        (_this$logger4 = this.logger) === null || _this$logger4 === void 0 ? void 0 : _this$logger4.error(err.message);
        (_this$counter5 = this.counter) === null || _this$counter5 === void 0 ? void 0 : _this$counter5.errorCounter(contextName);
      }));
      return;
    }

    // Nothing to do if the trigger interval is the same
  }
}
exports.InterceptTriggerService = InterceptTriggerService;