"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostMetrics = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _use_tab_switcher = require("../../../hooks/use_tab_switcher");
var _charts = require("../../../charts");
var _types = require("../../../types");
var _use_asset_details_render_props = require("../../../hooks/use_asset_details_render_props");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/tabs/overview/metrics/host_metrics.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const HostMetrics = props => {
  const {
    showTab
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const {
    schema
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const onClick = metric => {
    showTab(_types.ContentTabIds.METRICS, {
      scrollTo: metric
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.HostCharts, (0, _extends2.default)({}, props, {
    metric: "cpu",
    onShowAll: onClick,
    overview: true,
    schema: schema,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 2,
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 33,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.HostCharts, (0, _extends2.default)({}, props, {
    metric: "memory",
    onShowAll: onClick,
    overview: true,
    schema: schema,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_charts.HostCharts, (0, _extends2.default)({}, props, {
    metric: "network",
    onShowAll: onClick,
    overview: true,
    schema: schema,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 35,
      columnNumber: 9
    }
  }))), /*#__PURE__*/_react.default.createElement(_charts.HostCharts, (0, _extends2.default)({}, props, {
    metric: "disk",
    onShowAll: onClick,
    overview: true,
    schema: schema,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_charts.KubernetesNodeCharts, (0, _extends2.default)({}, props, {
    onShowAll: onClick,
    overview: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  })));
};
exports.HostMetrics = HostMetrics;