"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LinkToApmService = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _customIcons = require("@kbn/custom-icons");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/components/asset_details/links/link_to_apm_service.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LinkToApmService = ({
  serviceName,
  agentName,
  dateRange
}) => {
  const linkProps = (0, _public.useLinkProps)({
    app: 'apm',
    pathname: `/services/${serviceName}/overview`,
    search: {
      rangeFrom: dateRange.from,
      rangeTo: dateRange.to
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 30,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "serviceLink",
    color: "hollow",
    css: {
      padding: '4px'
    },
    href: linkProps.href,
    title: _i18n.i18n.translate('xpack.infra.assetDetails.services.serviceButtonTitle', {
      defaultMessage: '{serviceName} last reported by {agentName}',
      values: {
        serviceName,
        agentName
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 31,
      columnNumber: 7
    }
  }, agentName ? /*#__PURE__*/_react.default.createElement(_customIcons.AgentIcon, {
    agentName: agentName,
    size: "m",
    css: {
      marginRight: '4px'
    },
    role: "presentation",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 42,
      columnNumber: 11
    }
  }) : null, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": `serviceNameText-${serviceName}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 9
    }
  }, serviceName)));
};
exports.LinkToApmService = LinkToApmService;