"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Criteria = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _criterion2 = require("./criterion");
var _types = require("../../../../../common/alerting/logs/log_threshold/types");
var _editor = require("./editor");
var _criterion_preview_chart = require("./criterion_preview_chart");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/infra/public/alerting/log_threshold/components/expression_editor/criteria.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const QueryAText = _i18n.i18n.translate('xpack.infra.logs.alerting.threshold.ratioCriteriaQueryAText', {
  defaultMessage: 'Query A'
});
const QueryBText = _i18n.i18n.translate('xpack.infra.logs.alerting.threshold.ratioCriteriaQueryBText', {
  defaultMessage: 'Query B'
});
const Criteria = props => {
  const {
    criteria,
    errors
  } = props;
  if (!criteria || criteria.length === 0) return null;
  return !(0, _types.isRatioRule)(criteria) ? /*#__PURE__*/_react.default.createElement(CountCriteria, (0, _extends2.default)({}, props, {
    criteria: criteria,
    errors: errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 5
    }
  })) : /*#__PURE__*/_react.default.createElement(RatioCriteria, (0, _extends2.default)({}, props, {
    criteria: criteria,
    errors: errors,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 5
    }
  }));
};
exports.Criteria = Criteria;
const CriteriaWrapper = props => {
  const {
    updateCriterion,
    removeCriterion,
    addCriterion,
    criteria,
    fields,
    errors,
    ruleParams,
    logViewReference,
    isRatio = false
  } = props;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }, criteria.map((criterion, idx) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: `criterion-${idx}`,
      buttonContent: /*#__PURE__*/_react.default.createElement(_criterion2.Criterion, {
        idx: idx,
        fields: fields,
        criterion: criterion,
        updateCriterion: updateCriterion,
        removeCriterion: removeCriterion,
        canDelete: criteria.length > 1,
        errors: errors[idx],
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 97,
          columnNumber: 17
        }
      }),
      key: idx,
      arrowDisplay: "right",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_criterion_preview_chart.CriterionPreview, {
      ruleParams: ruleParams,
      chartCriterion: criterion,
      logViewReference: logViewReference,
      showThreshold: !isRatio,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 15
      }
    }));
  }), /*#__PURE__*/_react.default.createElement(AddCriterionButton, {
    addCriterion: addCriterion,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  })));
};
const RatioCriteria = props => {
  const {
    criteria,
    defaultCriterion,
    errors,
    updateCriteria
  } = props;
  const handleUpdateNumeratorCriteria = (0, _react.useCallback)(criteriaParam => {
    const nextCriteria = [criteriaParam, (0, _types.getDenominator)(criteria)];
    updateCriteria(nextCriteria);
  }, [updateCriteria, criteria]);
  const handleUpdateDenominatorCriteria = (0, _react.useCallback)(criteriaParam => {
    const nextCriteria = [(0, _types.getNumerator)(criteria), criteriaParam];
    updateCriteria(nextCriteria);
  }, [updateCriteria, criteria]);
  const {
    updateCriterion: updateNumeratorCriterion,
    addCriterion: addNumeratorCriterion,
    removeCriterion: removeNumeratorCriterion
  } = useCriteriaState((0, _types.getNumerator)(criteria), defaultCriterion, handleUpdateNumeratorCriteria);
  const {
    updateCriterion: updateDenominatorCriterion,
    addCriterion: addDenominatorCriterion,
    removeCriterion: removeDenominatorCriterion
  } = useCriteriaState((0, _types.getDenominator)(criteria), defaultCriterion, handleUpdateDenominatorCriteria);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 162,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_editor.ExpressionLike, {
    text: QueryAText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 164,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(CriteriaWrapper, (0, _extends2.default)({}, props, {
    criteria: (0, _types.getNumerator)(criteria),
    updateCriterion: updateNumeratorCriterion,
    addCriterion: addNumeratorCriterion,
    removeCriterion: removeNumeratorCriterion,
    errors: errors[0],
    isRatio: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 176,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_editor.ExpressionLike, {
    text: QueryBText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(CriteriaWrapper, (0, _extends2.default)({}, props, {
    criteria: (0, _types.getDenominator)(criteria),
    updateCriterion: updateDenominatorCriterion,
    addCriterion: addDenominatorCriterion,
    removeCriterion: removeDenominatorCriterion,
    errors: errors[1],
    isRatio: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 7
    }
  })));
};
const CountCriteria = props => {
  const {
    criteria,
    defaultCriterion,
    updateCriteria,
    errors
  } = props;
  const {
    updateCriterion,
    addCriterion,
    removeCriterion
  } = useCriteriaState(criteria, defaultCriterion, updateCriteria);
  return /*#__PURE__*/_react.default.createElement(CriteriaWrapper, (0, _extends2.default)({}, props, {
    updateCriterion: updateCriterion,
    addCriterion: addCriterion,
    removeCriterion: removeCriterion,
    errors: errors[0],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 207,
      columnNumber: 5
    }
  }));
};
const useCriteriaState = (criteria, defaultCriterion, onUpdateCriteria) => {
  const updateCriterion = (0, _react.useCallback)((idx, criterionParams) => {
    const nextCriteria = criteria.map((criterion, index) => {
      return idx === index ? {
        ...criterion,
        ...criterionParams
      } : criterion;
    });
    onUpdateCriteria(nextCriteria);
  }, [criteria, onUpdateCriteria]);
  const addCriterion = (0, _react.useCallback)(() => {
    const nextCriteria = [...criteria, defaultCriterion];
    onUpdateCriteria(nextCriteria);
  }, [criteria, defaultCriterion, onUpdateCriteria]);
  const removeCriterion = (0, _react.useCallback)(idx => {
    const nextCriteria = criteria.filter((_criterion, index) => {
      return index !== idx;
    });
    onUpdateCriteria(nextCriteria);
  }, [criteria, onUpdateCriteria]);
  return {
    updateCriterion,
    addCriterion,
    removeCriterion
  };
};
const AddCriterionButton = ({
  addCriterion
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 252,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraAddCriterionButtonAddConditionButton",
    color: 'primary',
    iconSide: 'left',
    flush: 'left',
    iconType: 'plusInCircleFilled',
    onClick: addCriterion,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 253,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logs.alertFlyout.addCondition",
    defaultMessage: "Add condition",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 261,
      columnNumber: 9
    }
  })));
};