"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConnectorById = void 0;
var _inferenceCommon = require("@kbn/inference-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Retrieves a connector given the provided `connectorId` and asserts it's an inference connector
 */
const getConnectorById = async ({
  connectorId,
  actions,
  request
}) => {
  let connector;
  try {
    const actionsClient = await actions.getActionsClientWithRequest(request);
    connector = await actionsClient.get({
      id: connectorId,
      throwIfSystemAction: true
    });
  } catch (error) {
    throw (0, _inferenceCommon.createInferenceRequestError)(`No connector found for id '${connectorId}'\n${error.message}`, 400);
  }
  return (0, _inferenceCommon.connectorToInference)(connector);
};
exports.getConnectorById = getConnectorById;