"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LegacyTemplateTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _analytics = require("@kbn/analytics");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _constants = require("../../../../../../../common/constants");
var _components = require("../../../../../components");
var _routing = require("../../../../../services/routing");
var _app_context = require("../../../../../app_context");
var _shared = require("../../../../../components/shared");
var _components2 = require("../../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/sections/home/template_list/legacy_templates/template_table/template_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LegacyTemplateTable = ({
  templates,
  reload,
  editTemplate,
  cloneTemplate,
  history
}) => {
  const {
    uiMetricService
  } = (0, _app_context.useServices)();
  const [selection, setSelection] = (0, _react.useState)([]);
  const [templatesToDelete, setTemplatesToDelete] = (0, _react.useState)([]);
  const columns = [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.idxMgmt.templateList.legacyTable.nameColumnTitle', {
      defaultMessage: 'Name'
    }),
    truncateText: true,
    sortable: true,
    render: (name, item) => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _shared_imports.reactRouterNavigate)(history, (0, _routing.getTemplateDetailsLink)(name, Boolean(item._kbnMeta.isLegacy)), () => uiMetricService.trackMetric(_analytics.METRIC_TYPE.CLICK, _constants.UIM_TEMPLATE_SHOW_DETAILS_CLICK)), {
        "data-test-subj": "templateDetailsLink",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 57,
          columnNumber: 13
        }
      }), name), "\xA0", /*#__PURE__*/_react.default.createElement(_components2.TemplateTypeIndicator, {
        templateType: item._kbnMeta.type,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 69,
          columnNumber: 13
        }
      }));
    }
  }, {
    field: 'indexPatterns',
    name: _i18n.i18n.translate('xpack.idxMgmt.templateList.legacyTable.indexPatternsColumnTitle', {
      defaultMessage: 'Index patterns'
    }),
    truncateText: true,
    sortable: true,
    render: indexPatterns => /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 44
      }
    }, indexPatterns.join(', '))
  }, {
    field: 'ilmPolicy',
    name: _i18n.i18n.translate('xpack.idxMgmt.templateList.legacyTable.ilmPolicyColumnTitle', {
      defaultMessage: 'ILM policy'
    }),
    truncateText: true,
    sortable: true,
    render: ilmPolicy => ilmPolicy && ilmPolicy.name ? /*#__PURE__*/_react.default.createElement("span", {
      title: _i18n.i18n.translate('xpack.idxMgmt.templateList.legacyTable.ilmPolicyColumnDescription', {
        defaultMessage: "''{policyName}'' index lifecycle policy",
        values: {
          policyName: ilmPolicy.name
        }
      }),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 92,
        columnNumber: 11
      }
    }, ilmPolicy.name) : null
  }, {
    name: _i18n.i18n.translate('xpack.idxMgmt.templateList.legacyTable.contentColumnTitle', {
      defaultMessage: 'Content'
    }),
    width: '120px',
    render: item => /*#__PURE__*/_react.default.createElement(_shared.TemplateContentIndicator, {
      mappings: item.hasMappings,
      settings: item.hasSettings,
      aliases: item.hasAliases,
      contentWhenEmpty: /*#__PURE__*/_react.default.createElement("em", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 118,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.idxMgmt.templateList.table.noneDescriptionText', {
        defaultMessage: 'None'
      })),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 9
      }
    })
  }, {
    name: _i18n.i18n.translate('xpack.idxMgmt.templateList.legacyTable.actionColumnTitle', {
      defaultMessage: 'Actions'
    }),
    width: '120px',
    actions: [{
      name: _i18n.i18n.translate('xpack.idxMgmt.templateList.legacyTable.actionEditText', {
        defaultMessage: 'Edit'
      }),
      isPrimary: true,
      description: _i18n.i18n.translate('xpack.idxMgmt.templateList.legacyTable.actionEditDecription', {
        defaultMessage: 'Edit this template'
      }),
      icon: 'pencil',
      type: 'icon',
      onClick: ({
        name
      }) => {
        editTemplate(name, true);
      },
      enabled: ({
        _kbnMeta: {
          type
        }
      }) => type !== 'cloudManaged'
    }, {
      type: 'icon',
      name: _i18n.i18n.translate('xpack.idxMgmt.templateList.legacyTable.actionCloneTitle', {
        defaultMessage: 'Clone'
      }),
      description: _i18n.i18n.translate('xpack.idxMgmt.templateList.legacyTable.actionCloneDescription', {
        defaultMessage: 'Clone this template'
      }),
      icon: 'copy',
      onClick: ({
        name
      }) => {
        cloneTemplate(name, true);
      }
    }, {
      name: _i18n.i18n.translate('xpack.idxMgmt.templateList.legacyTable.actionDeleteText', {
        defaultMessage: 'Delete'
      }),
      description: _i18n.i18n.translate('xpack.idxMgmt.templateList.legacyTable.actionDeleteDecription', {
        defaultMessage: 'Delete this template'
      }),
      icon: 'trash',
      color: 'danger',
      type: 'icon',
      onClick: ({
        name,
        _kbnMeta: {
          isLegacy
        }
      }) => {
        setTemplatesToDelete([{
          name,
          isLegacy
        }]);
      },
      isPrimary: true,
      enabled: ({
        _kbnMeta: {
          type
        }
      }) => type !== 'cloudManaged'
    }]
  }];
  const pagination = {
    initialPageSize: 20,
    pageSizeOptions: [10, 20, 50]
  };
  const sorting = {
    sort: {
      field: 'name',
      direction: 'asc'
    }
  };
  const selectionConfig = {
    onSelectionChange: setSelection,
    selectable: ({
      _kbnMeta: {
        type
      }
    }) => type !== 'cloudManaged',
    selectableMessage: selectable => {
      if (!selectable) {
        return _i18n.i18n.translate('xpack.idxMgmt.templateList.legacyTable.deleteCloudManagedTemplateTooltip', {
          defaultMessage: 'You cannot delete a cloud-managed template.'
        });
      }
      return '';
    }
  };
  const searchConfig = {
    box: {
      incremental: true
    },
    toolsLeft: selection.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "deleteTemplatesButton",
      onClick: () => setTemplatesToDelete(selection.map(({
        name,
        _kbnMeta: {
          isLegacy
        }
      }) => ({
        name,
        isLegacy
      }))),
      color: "danger",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 224,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateList.legacyTable.deleteTemplatesButtonLabel",
      defaultMessage: "Delete {count, plural, one {template} other {templates} }",
      values: {
        count: selection.length
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 11
      }
    })) : undefined,
    toolsRight: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
      iconType: "plusInCircle",
      "data-test-subj": "createLegacyTemplateButton",
      key: "createTemplateButton"
    }, (0, _shared_imports.reactRouterNavigate)(history, {
      pathname: '/create_template',
      search: 'legacy=true'
    }), {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 244,
        columnNumber: 7
      }
    }), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateList.legacyTable.createLegacyTemplatesButtonLabel",
      defaultMessage: "Create legacy template",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 253,
        columnNumber: 9
      }
    }))]
  };
  const goToList = () => {
    return history.push('templates');
  };
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 266,
      columnNumber: 5
    }
  }, templatesToDelete && templatesToDelete.length > 0 ? /*#__PURE__*/_react.default.createElement(_components.TemplateDeleteModal, {
    callback: data => {
      if (data && data.hasDeletedTemplates) {
        reload();
        // Close the flyout if it is opened
        goToList();
      }
      setTemplatesToDelete([]);
    },
    templatesToDelete: templatesToDelete,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 268,
      columnNumber: 9
    }
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: templates || [],
    itemId: "name",
    columns: columns,
    search: searchConfig,
    sorting: sorting,
    selection: selectionConfig,
    pagination: pagination,
    rowProps: () => ({
      'data-test-subj': 'row'
    }),
    cellProps: () => ({
      'data-test-subj': 'cell'
    }),
    "data-test-subj": "legacyTemplateTable",
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateList.legacyTable.noLegacyIndexTemplatesMessage",
      defaultMessage: "No legacy index templates found",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 296,
        columnNumber: 11
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 280,
      columnNumber: 7
    }
  }));
};
exports.LegacyTemplateTable = LegacyTemplateTable;