"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteRuntimeFieldProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _mappings_state_context = require("../../mappings_state_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/runtime_fields/delete_field_provider.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeleteRuntimeFieldProvider = ({
  children
}) => {
  const [state, setState] = (0, _react.useState)({
    isModalOpen: false
  });
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const confirmButtonText = _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.deleteRuntimeField.confirmationModal.removeButtonLabel', {
    defaultMessage: 'Remove'
  });
  let modalTitle;
  if (state.field) {
    const {
      source
    } = state.field;
    modalTitle = _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.deleteRuntimeField.confirmationModal.title', {
      defaultMessage: "Remove runtime field ''{fieldName}''?",
      values: {
        fieldName: source.name
      }
    });
  }
  const deleteField = field => {
    setState({
      isModalOpen: true,
      field
    });
  };
  const closeModal = () => {
    setState({
      isModalOpen: false
    });
  };
  const confirmDelete = () => {
    dispatch({
      type: 'runtimeField.remove',
      value: state.field.id
    });
    closeModal();
  };
  const modalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children(deleteField), state.isModalOpen && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": modalTitleId,
    title: modalTitle,
    titleProps: {
      id: modalTitleId
    },
    "data-test-subj": "runtimeFieldDeleteConfirmModal",
    onCancel: closeModal,
    onConfirm: confirmDelete,
    cancelButtonText: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.deleteRuntimeField.confirmationModal.cancelButtonLabel', {
      defaultMessage: 'Cancel'
    }),
    buttonColor: "danger",
    confirmButtonText: confirmButtonText,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  }));
};
exports.DeleteRuntimeFieldProvider = DeleteRuntimeFieldProvider;