"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IgnoreMalformedParameter = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _documentation = require("../../../../../services/documentation");
var _edit_field = require("../fields/edit_field");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/components/mappings_editor/components/document_fields/field_parameters/ignore_malformed.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const IgnoreMalformedParameter = ({
  description
}) => /*#__PURE__*/_react.default.createElement(_edit_field.EditFieldFormRow, {
  title: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.ignoreMalformedFieldTitle', {
    defaultMessage: 'Ignore malformed data'
  }),
  description: description ? description : _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.ignoredMalformedFieldDescription', {
    defaultMessage: 'By default, documents that contain the wrong data type for a field are not indexed. If enabled, these documents are indexed, but fields with the wrong data type are filtered out. Be careful: if too many documents are indexed this way, queries on the field become meaningless.'
  }),
  docLink: {
    text: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.ignoreMalformedDocLinkText', {
      defaultMessage: 'Ignore malformed documentation'
    }),
    href: _documentation.documentationService.getIgnoreMalformedLink()
  },
  formFieldPath: "ignore_malformed",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 16,
    columnNumber: 3
  }
});
exports.IgnoreMalformedParameter = IgnoreMalformedParameter;