"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppWithoutRouter = exports.App = void 0;
var _react = _interopRequireWildcard(require("react"));
var _analytics = require("@kbn/analytics");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _constants = require("../../common/constants");
var _home = require("./sections/home");
var _template_create = require("./sections/template_create");
var _template_clone = require("./sections/template_clone");
var _template_edit = require("./sections/template_edit");
var _enrich_policy_create = require("./sections/enrich_policy_create");
var _app_context = require("./app_context");
var _components = require("./components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/index_management/public/application/app.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const App = ({
  history
}) => {
  const {
    services
  } = (0, _app_context.useAppContext)();
  (0, _react.useEffect)(() => services.uiMetricService.trackMetric(_analytics.METRIC_TYPE.LOADED, _constants.UIM_APP_LOAD), [services.uiMetricService]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(AppWithoutRouter, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }));
};

// Export this so we can test it with a different router.
exports.App = App;
const AppWithoutRouter = () => /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 44,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/create_template",
  component: _template_create.TemplateCreate,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 45,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/clone_template/:name*",
  component: _template_clone.TemplateClone,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 46,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/edit_template/:name*",
  component: _template_edit.TemplateEdit,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 47,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/create_component_template",
  component: _components.ComponentTemplateCreate,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 48,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/create_component_template/:sourceComponentTemplateName",
  component: _components.ComponentTemplateClone,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 49,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/edit_component_template/:name*",
  component: _components.ComponentTemplateEdit,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 54,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/enrich_policies/create",
  component: _enrich_policy_create.EnrichPolicyCreate,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 55,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  path: `/:section(${_home.homeSections.join('|')})`,
  component: _home.IndexManagementHome,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 56,
    columnNumber: 5
  }
}), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
  from: `/`,
  to: `/${_constants.Section.Indices}`,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 57,
    columnNumber: 5
  }
}));
exports.AppWithoutRouter = AppWithoutRouter;