"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnhancedUseField = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _hook_form_lib = require("@kbn/es-ui-shared-plugin/static/forms/hook_form_lib");
var _form_errors_context = require("../form_errors_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/index_lifecycle_management/public/application/sections/edit_policy/form/components/enhanced_use_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// We wrap this component for edit policy so we do not export it from the "shared_imports" dir to avoid
// accidentally using the non-enhanced version.
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const isXPhaseField = phase => fieldPath => fieldPath.startsWith(`phases.${phase}`) || fieldPath.startsWith(`_meta.${phase}`);
const isHotPhaseField = isXPhaseField('hot');
const isWarmPhaseField = isXPhaseField('warm');
const isColdPhaseField = isXPhaseField('cold');
const isFrozenPhaseField = isXPhaseField('frozen');
const isDeletePhaseField = isXPhaseField('delete');
const determineFieldPhase = fieldPath => {
  if (isHotPhaseField(fieldPath)) {
    return 'hot';
  }
  if (isWarmPhaseField(fieldPath)) {
    return 'warm';
  }
  if (isColdPhaseField(fieldPath)) {
    return 'cold';
  }
  if (isFrozenPhaseField(fieldPath)) {
    return 'frozen';
  }
  if (isDeletePhaseField(fieldPath)) {
    return 'delete';
  }
  return 'other';
};
const EnhancedUseField = props => {
  const {
    path
  } = props;
  const isMounted = (0, _react.useRef)(false);
  const phase = (0, _react.useMemo)(() => determineFieldPhase(path), [path]);
  const {
    addError,
    clearError
  } = (0, _form_errors_context.useFormErrorsContext)();
  const onError = (0, _react.useCallback)(errors => {
    if (!isMounted.current) {
      return;
    }
    if (errors) {
      addError(phase, path, errors);
    } else {
      clearError(phase, path);
    }
  }, [phase, path, addError, clearError]);
  (0, _react.useEffect)(() => {
    isMounted.current = true;
    return () => {
      isMounted.current = false;
    };
  }, []);

  // Make sure to clear error message if the field is unmounted.
  (0, _react.useEffect)(() => {
    return () => {
      if (isMounted.current === false) {
        clearError(phase, path);
      }
    };
  }, [phase, path, clearError]);
  return /*#__PURE__*/_react.default.createElement(_hook_form_lib.UseField, (0, _extends2.default)({}, props, {
    onError: onError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 10
    }
  }));
};
exports.EnhancedUseField = EnhancedUseField;