"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isLiteralValue = isLiteralValue;
exports.isNamedField = isNamedField;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Type guard to check if a node is a NamedFieldNode.
 */
function isNamedField(node) {
  return 'id' in node;
}

/*
 * Type guard to check if a node is a LiteralValueNode.
 */
function isLiteralValue(node) {
  return !('id' in node);
}