"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports._runBulkRollbackTask = _runBulkRollbackTask;
exports.scheduleBulkRollback = scheduleBulkRollback;
var _common = require("@kbn/spaces-plugin/common");
var _services = require("../../services");
var _rollback = require("../../services/epm/packages/rollback");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function _runBulkRollbackTask({
  abortController,
  taskParams,
  logger
}) {
  const {
    packages,
    spaceId = _common.DEFAULT_SPACE_ID,
    packagePolicyIdsForCurrentUser
  } = taskParams;
  const esClient = _services.appContextService.getInternalUserESClient();
  const results = [];
  for (const pkg of packages) {
    // Throw between package rollback if task is aborted
    if (abortController.signal.aborted) {
      throw new Error('Task was aborted');
    }
    try {
      const response = await (0, _rollback.rollbackInstallation)({
        esClient,
        currentUserPolicyIds: packagePolicyIdsForCurrentUser[pkg.name],
        pkgName: pkg.name,
        spaceId
      });
      _services.appContextService.getLogger().info(JSON.stringify(response));
      results.push({
        name: pkg.name,
        success: true
      });
    } catch (error) {
      logger.error(`Rollback of package: ${pkg.name} failed`, {
        error
      });
      results.push({
        name: pkg.name,
        success: false,
        error: (0, _utils.formatError)(error)
      });
    }
  }
  return results;
}
async function scheduleBulkRollback(taskManagerStart, taskParams) {
  return (0, _utils.scheduleBulkOperationTask)(taskManagerStart, {
    ...taskParams,
    type: 'bulk_rollback'
  });
}