"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateRequiredVersions = validateRequiredVersions;
var _lodash = require("lodash");
var _errors = require("../../errors");
var _ = require("..");
var _agent_utils = require("../../../common/services/agent_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateRequiredVersions(name, requiredVersions, previousRequiredVersions, isAuthorized) {
  if (!requiredVersions) {
    return;
  }
  if (!_.appContextService.getExperimentalFeatures().enableAutomaticAgentUpgrades) {
    throw new _errors.AgentPolicyInvalidError(`Policy "${name}" failed validation: required_versions are not allowed when automatic upgrades feature is disabled`);
  }
  if (requiredVersions && !_.licenseService.isEnterprise()) {
    throw new _errors.FleetUnauthorizedError('Agents auto upgrades feature requires at least Enterprise license');
  }
  const error = (0, _agent_utils.checkTargetVersionsValidity)(requiredVersions);
  if (error) {
    throw new _errors.AgentPolicyInvalidError(`Policy "${name}" failed required_versions validation: ${error}`);
  }
  if (isAuthorized === undefined) {
    return;
  }
  const isChange = !(0, _lodash.isEqual)(requiredVersions, previousRequiredVersions);
  if (isChange && !isAuthorized) {
    throw new _errors.FleetUnauthorizedError(`updating 'required_versions' requires Agents 'All' privilege`);
  }
}