"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.confirmUpdate = confirmUpdate;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _agent_and_policies_count = require("../../services/agent_and_policies_count");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/fleet/public/applications/fleet/sections/settings/components/edit_output_flyout/confirm_update.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ConfirmTitle = () => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.updateOutput.confirmModalTitle",
  defaultMessage: "Save and deploy changes?",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 17,
    columnNumber: 3
  }
});
const ConfirmDescription = ({
  output,
  agentCount,
  agentPolicyCount
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, agentCount !== undefined && agentPolicyCount !== undefined ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  "data-test-subj": "settings.outputModal",
  id: "xpack.fleet.settings.updateOutput.confirmModalText",
  defaultMessage: "This action will update {outputName} output. It will update {policies} and {agents}. This action can not be undone. Are you sure you wish to continue?",
  values: {
    outputName: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 23
      }
    }, output.name),
    agents: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.updateOutput.agentsCount",
      defaultMessage: "{agentCount, plural, one {# agent} other {# agents}}",
      values: {
        agentCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 15
      }
    })),
    policies: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.fleet.settings.updateOutput.agentPolicyCount",
      defaultMessage: "{agentPolicyCount, plural, one {# agent policy} other {# agent policies}}",
      values: {
        agentPolicyCount
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 55,
        columnNumber: 15
      }
    }))
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 36,
    columnNumber: 7
  }
}) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  "data-test-subj": "settings.outputModal",
  id: "xpack.fleet.settings.updateOutput.confirmModalTextWithoutCount",
  defaultMessage: "This action will update {outputName} output. It will update related policies and agents. This action can not be undone. Are you sure you wish to continue?",
  values: {
    outputName: /*#__PURE__*/_react.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 23
      }
    }, output.name)
  },
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 67,
    columnNumber: 7
  }
}), output.type === 'logstash' ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "s",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 79,
    columnNumber: 9
  }
}), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
  iconType: "warning",
  color: "warning",
  size: "m",
  title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.fleet.settings.updateOutput.warningTitle",
    defaultMessage: "Logstash output for agent integration is not supported for fleet server and synthetics.",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 13
    }
  }),
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 80,
    columnNumber: 9
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.fleet.settings.updateOutput.warningMessage",
  defaultMessage: "Fleet server and synthetics policies will keep using the existing ES output.",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 91,
    columnNumber: 11
  }
})), ' ') : null);
async function confirmUpdate(output, confirm) {
  const {
    agentCount,
    agentPolicyCount
  } =
  // Fail gracefully if not agent and policy count not available
  await (0, _agent_and_policies_count.getAgentAndPolicyCountForOutput)(output).catch(() => ({
    agentCount: undefined,
    agentPolicyCount: undefined
  }));
  return confirm(/*#__PURE__*/_react.default.createElement(ConfirmTitle, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 113,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(ConfirmDescription, {
    agentCount: agentCount,
    agentPolicyCount: agentPolicyCount,
    output: output,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 5
    }
  }));
}