"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tooltip = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _utils = require("@kbn/visualizations-plugin/common/utils");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _helpers = require("../../helpers");
var _endzone_tooltip_header = require("./endzone_tooltip_header");
var _tooltip_row = require("./tooltip_row");
var _utils2 = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763985831484149691/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/chart_expressions/expression_xy/public/components/tooltip/tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const Tooltip = ({
  header,
  values,
  fieldFormats,
  titles = {},
  formatFactory,
  formattedDatatables,
  splitAccessors,
  xDomain,
  layers
}) => {
  var _layers$find;
  const pickedValue = values.find(({
    isHighlighted
  }) => isHighlighted);
  if (!pickedValue) {
    return null;
  }
  const data = [];
  const seriesIdentifier = pickedValue.seriesIdentifier;
  const {
    layerId,
    xAccessor,
    yAccessors
  } = (0, _helpers.getMetaFromSeriesId)(seriesIdentifier.specId);
  const {
    formattedColumns,
    table
  } = formattedDatatables[layerId];
  const layerTitles = titles[layerId];
  const layerFormats = fieldFormats[layerId];
  const markSizeAccessor = (_layers$find = layers.find(layer => layer.layerId === layerId)) === null || _layers$find === void 0 ? void 0 : _layers$find.markSizeAccessor;
  const markSizeColumnId = markSizeAccessor ? (0, _utils.getAccessorByDimension)(markSizeAccessor, table.columns) : undefined;
  let headerFormatter;
  if (header && xAccessor) {
    var _layerTitles$xTitles;
    headerFormatter = formattedColumns[xAccessor] ? null : formatFactory(layerFormats.xAccessors[xAccessor]);
    data.push({
      label: layerTitles === null || layerTitles === void 0 ? void 0 : (_layerTitles$xTitles = layerTitles.xTitles) === null || _layerTitles$xTitles === void 0 ? void 0 : _layerTitles$xTitles[xAccessor],
      value: headerFormatter ? headerFormatter.convert(header.value) : `${header.value}`
    });
  }
  const tooltipYAccessor = yAccessors.includes(seriesIdentifier.yAccessor) ? seriesIdentifier.yAccessor : null;
  if (tooltipYAccessor) {
    var _layerTitles$yTitles;
    const yFormatter = formatFactory(layerFormats.yAccessors[tooltipYAccessor]);
    data.push({
      label: layerTitles === null || layerTitles === void 0 ? void 0 : (_layerTitles$yTitles = layerTitles.yTitles) === null || _layerTitles$yTitles === void 0 ? void 0 : _layerTitles$yTitles[tooltipYAccessor],
      value: yFormatter ? yFormatter.convert(pickedValue.value) : `${pickedValue.value}`
    });
  }
  if (markSizeColumnId && pickedValue.formattedMarkValue) {
    var _layerTitles$markSize;
    data.push({
      label: layerTitles === null || layerTitles === void 0 ? void 0 : (_layerTitles$markSize = layerTitles.markSizeTitles) === null || _layerTitles$markSize === void 0 ? void 0 : _layerTitles$markSize[markSizeColumnId],
      value: pickedValue.formattedMarkValue
    });
  }
  seriesIdentifier.splitAccessors.forEach((splitValue, key) => {
    var _layerTitles$splitSer;
    const splitSeriesFormatter = formattedColumns[key] ? null : layerFormats.splitSeriesAccessors[key].formatter;
    const label = layerTitles === null || layerTitles === void 0 ? void 0 : (_layerTitles$splitSer = layerTitles.splitSeriesTitles) === null || _layerTitles$splitSer === void 0 ? void 0 : _layerTitles$splitSer[key];
    const value = splitSeriesFormatter ? splitSeriesFormatter.convert(splitValue) : `${splitValue}`;
    data.push({
      label,
      value
    });
  });
  if (splitAccessors !== null && splitAccessors !== void 0 && splitAccessors.splitColumnAccessor && seriesIdentifier.smHorizontalAccessorValue !== undefined) {
    var _layerTitles$splitCol;
    data.push({
      label: layerTitles === null || layerTitles === void 0 ? void 0 : (_layerTitles$splitCol = layerTitles.splitColumnTitles) === null || _layerTitles$splitCol === void 0 ? void 0 : _layerTitles$splitCol[splitAccessors === null || splitAccessors === void 0 ? void 0 : splitAccessors.splitColumnAccessor],
      value: `${seriesIdentifier.smHorizontalAccessorValue}`
    });
  }
  if (splitAccessors !== null && splitAccessors !== void 0 && splitAccessors.splitRowAccessor && seriesIdentifier.smVerticalAccessorValue !== undefined) {
    var _layerTitles$splitRow;
    data.push({
      label: layerTitles === null || layerTitles === void 0 ? void 0 : (_layerTitles$splitRow = layerTitles.splitRowTitles) === null || _layerTitles$splitRow === void 0 ? void 0 : _layerTitles$splitRow[splitAccessors === null || splitAccessors === void 0 ? void 0 : splitAccessors.splitRowAccessor],
      value: `${seriesIdentifier.smVerticalAccessorValue}`
    });
  }
  const tooltipRows = data.map((tooltipRow, index) => /*#__PURE__*/_react.default.createElement(_tooltip_row.TooltipRow, (0, _extends2.default)({}, tooltipRow, {
    key: `${tooltipRow.label}-${tooltipRow.value}-${index}`,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  })));
  const renderEndzoneTooltip = header ? (0, _utils2.isEndzoneBucket)(header === null || header === void 0 ? void 0 : header.value, xDomain) : false;
  return /*#__PURE__*/_react.default.createElement("div", {
    css: styles.customToolTip,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 5
    }
  }, renderEndzoneTooltip && /*#__PURE__*/_react.default.createElement("div", {
    css: styles.header,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_endzone_tooltip_header.EndzoneTooltipHeader, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("table", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("tbody", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  }, tooltipRows)));
};
exports.Tooltip = Tooltip;
const styles = {
  header: ({
    euiTheme
  }) => (0, _react2.css)`
    > :last-child {
      margin-bottom: ${euiTheme.size.s};
    }
  `,
  customToolTip: euiThemeContext => (0, _react2.css)`
      z-index: ${euiThemeContext.euiTheme.levels.toast};
      pointer-events: none;

      padding: ${euiThemeContext.euiTheme.size.s};
      border-radius: ${euiThemeContext.euiTheme.border.radius.medium};
      max-width: calc(${euiThemeContext.euiTheme.size.xl} * 10);
      overflow: hidden;
      border: ${euiThemeContext.euiTheme.border.width.thin} solid
        ${euiThemeContext.euiTheme.components.tooltipBorderFloating};

      ${(0, _eui.euiFontSize)(euiThemeContext, 's')}
      color: ${euiThemeContext.euiTheme.colors.textParagraph};

      ${(0, _eui.euiShadow)(euiThemeContext)}
      background-color: ${euiThemeContext.euiTheme.colors.backgroundBasePlain};

      table {
        table-layout: fixed;
        width: 100%;

        td,
        th {
          text-align: left;
          padding: ${euiThemeContext.euiTheme.size.xs};
          overflow-wrap: break-word;
        }
      }
    `
};