"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteAnalyticsCollectionById = void 0;
var _error_codes = require("../../../common/types/error_codes");
var _identify_exceptions = require("../../utils/identify_exceptions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const deleteAnalyticsCollectionById = async (client, name) => {
  try {
    await client.asCurrentUser.searchApplication.deleteBehavioralAnalytics({
      name
    });
  } catch (error) {
    if ((0, _identify_exceptions.isResourceNotFoundException)(error)) {
      throw new Error(_error_codes.ErrorCode.ANALYTICS_COLLECTION_NOT_FOUND);
    }
    throw error;
  }
};
exports.deleteAnalyticsCollectionById = deleteAnalyticsCollectionById;